/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.authentication;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.model.user.InternalUser;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class PasswordHelper {
    private static final Logger logger = Logger.getLogger(PasswordHelper.class);

    public boolean validateRegex(String regex, PasswordCredential credential) {
        boolean valid = false;
        if (credential != null) {
            Pattern pattern = Pattern.compile(regex);
            valid = pattern.matcher(credential.getCredential()).find();
        }
        return valid;
    }

    public boolean isUniquePassword(PasswordCredential newCredential, InternalUser user, int lastPasswordsToCheck) {
        Validate.isTrue((boolean)newCredential.isEncryptedCredential());
        if (newCredential.equals((Object)user.getCredential())) {
            return false;
        }
        List credentialHistory = user.getCredentialHistory();
        if (lastPasswordsToCheck > credentialHistory.size()) {
            lastPasswordsToCheck = credentialHistory.size();
        }
        for (int i = credentialHistory.size() - lastPasswordsToCheck; i < credentialHistory.size(); ++i) {
            PasswordCredential oldCredential = (PasswordCredential)credentialHistory.get(i);
            if (!oldCredential.equals((Object)newCredential)) continue;
            return false;
        }
        return true;
    }

    public String generateRandomPassword() {
        return RandomStringUtils.randomAlphanumeric((int)8);
    }
}

