/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.stage;

import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.TransformContext;
import com.atlassian.plugin.osgi.factory.transform.TransformStage;
import com.atlassian.plugin.osgi.factory.transform.model.SystemExports;
import com.atlassian.plugin.osgi.factory.transform.stage.SpringHelper;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.parsers.XmlDescriptorParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateManifestStage
implements TransformStage {
    private static final String SPRING_CONTEXT_DEFAULT = "*;timeout:=60";
    static Log log = LogFactory.getLog(GenerateManifestStage.class);

    @Override
    public void execute(TransformContext context) throws PluginTransformationException {
        Builder builder = new Builder();
        try {
            builder.setJar(context.getPluginFile());
            XmlDescriptorParser parser = new XmlDescriptorParser(context.getDescriptorDocument(), null);
            if (this.isOsgiBundle(builder.getJar().getManifest())) {
                if (context.getExtraImports().isEmpty()) {
                    Manifest mf = builder.getJar().getManifest();
                    mf.getMainAttributes().putValue("Atlassian-Plugin-Key", parser.getKey());
                    this.validateOsgiVersionIsValid(mf);
                    this.writeManifestOverride(context, mf);
                    return;
                }
                GenerateManifestStage.assertSpringAvailableIfRequired(context);
                String imports = this.addExtraImports(builder.getJar().getManifest().getMainAttributes().getValue("Import-Package"), context.getExtraImports());
                builder.setProperty("Import-Package", imports);
                builder.setProperty("Atlassian-Plugin-Key", parser.getKey());
                builder.mergeManifest(builder.getJar().getManifest());
            } else {
                PluginInformation info = parser.getPluginInformation();
                Properties properties = new Properties();
                if (SpringHelper.isSpringUsed(context)) {
                    properties.put("Spring-Context", SPRING_CONTEXT_DEFAULT);
                }
                properties.put("Bundle-SymbolicName", parser.getKey());
                properties.put("Import-Package", "*;resolution:=optional");
                properties.put("Bundle-Version", info.getVersion());
                properties.put("-removeheaders", "Include-Resource");
                GenerateManifestStage.header(properties, "Bundle-Description", info.getDescription());
                GenerateManifestStage.header(properties, "Bundle-Name", parser.getKey());
                GenerateManifestStage.header(properties, "Bundle-Vendor", info.getVendorName());
                GenerateManifestStage.header(properties, "Bundle-DocURL", info.getVendorUrl());
                GenerateManifestStage.header(properties, "Atlassian-Plugin-Key", parser.getKey());
                StringBuilder classpath = new StringBuilder();
                classpath.append(".");
                for (JarEntry jarEntry : context.getPluginJarEntries()) {
                    if (!jarEntry.getName().startsWith("META-INF/lib/") || !jarEntry.getName().endsWith(".jar")) continue;
                    classpath.append(",").append(jarEntry.getName());
                }
                GenerateManifestStage.header(properties, "Bundle-ClassPath", classpath.toString());
                properties.putAll(context.getBndInstructions());
                properties.put("Import-Package", this.addExtraImports(properties.getProperty("Import-Package"), context.getExtraImports()));
                if (!properties.containsKey("Export-Package")) {
                    properties.put("Export-Package", StringUtils.join(context.getExtraExports(), (char)','));
                }
                builder.setProperties(properties);
            }
            builder.calcManifest();
            builder.getJar().close();
            Jar jar = builder.build();
            Manifest mf = jar.getManifest();
            this.enforceHostVersionsForUnknownImports(mf, context.getSystemExports());
            this.validateOsgiVersionIsValid(mf);
            this.writeManifestOverride(context, mf);
            jar.close();
        }
        catch (Exception t) {
            throw new PluginParseException("Unable to process plugin to generate OSGi manifest", (Throwable)t);
        }
        finally {
            builder.getJar().close();
            builder.close();
        }
    }

    private void validateOsgiVersionIsValid(Manifest mf) {
        String version = mf.getMainAttributes().getValue("Bundle-Version");
        try {
            if (Version.parseVersion((String)version) == Version.emptyVersion) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Plugin version '" + version + "' is required and must be able to be " + "parsed as an OSGi version - MAJOR.MINOR.MICRO.QUALIFIER");
        }
    }

    private void writeManifestOverride(TransformContext context, Manifest mf) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        mf.write(bout);
        context.getFileOverrides().put("META-INF/MANIFEST.MF", bout.toByteArray());
    }

    private void enforceHostVersionsForUnknownImports(Manifest manifest, SystemExports exports) {
        String origImports = manifest.getMainAttributes().getValue("Import-Package");
        if (origImports != null) {
            StringBuilder imports = new StringBuilder();
            Map<String, Map<String, String>> header = OsgiHeaderUtil.parseHeader(origImports);
            for (Map.Entry<String, Map<String, String>> pkgImport : header.entrySet()) {
                String export;
                String imp = null;
                if (pkgImport.getValue().isEmpty() && !(export = exports.getFullExport(pkgImport.getKey())).equals(imp)) {
                    imp = export;
                }
                if (imp == null) {
                    imp = OsgiHeaderUtil.buildHeader(pkgImport.getKey(), pkgImport.getValue());
                }
                imports.append(imp);
                imports.append(",");
            }
            if (imports.length() > 0) {
                imports.deleteCharAt(imports.length() - 1);
            }
            manifest.getMainAttributes().putValue("Import-Package", imports.toString());
        }
    }

    private boolean isOsgiBundle(Manifest manifest) throws IOException {
        return manifest.getMainAttributes().getValue("Bundle-SymbolicName") != null;
    }

    private String addExtraImports(String imports, List<String> extraImports) {
        StringBuilder referrers = new StringBuilder();
        for (String imp : extraImports) {
            referrers.append(imp).append(",");
        }
        imports = imports != null && imports.length() > 0 ? referrers + imports : referrers.toString();
        return imports;
    }

    private static void header(Properties properties, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return;
        }
        properties.put(key, value.toString().replaceAll("[\r\n]", ""));
    }

    private static void assertSpringAvailableIfRequired(TransformContext context) {
        if (context.shouldRequireSpring()) {
            String header = context.getManifest().getMainAttributes().getValue("Spring-Context");
            if (header == null) {
                log.debug((Object)("The Spring Manifest header 'Spring-Context' is missing in jar '" + context.getPluginArtifact().toString() + "'.  If you experience any problems, please add it and set it to '" + SPRING_CONTEXT_DEFAULT + "'"));
            } else if (!header.contains(";timeout:=60")) {
                log.warn((Object)("The Spring Manifest header in jar '" + context.getPluginArtifact().toString() + "' isn't " + "set for a 60 second timeout waiting for  dependencies.  Please add ';timeout:=60'"));
            }
        }
    }
}

