/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.stage;

import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.TransformContext;
import com.atlassian.plugin.osgi.factory.transform.TransformStage;
import com.atlassian.plugin.osgi.factory.transform.stage.SpringHelper;
import com.atlassian.plugin.util.PluginUtils;
import com.atlassian.plugin.util.validation.ValidationPattern;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class ComponentSpringStage
implements TransformStage {
    private static final String SPRING_XML = "META-INF/spring/atlassian-plugins-components.xml";

    public void execute(TransformContext context) throws PluginTransformationException {
        if (SpringHelper.shouldGenerateFile(context, SPRING_XML)) {
            Document springDoc = SpringHelper.createSpringDocument();
            Element root = springDoc.getRootElement();
            List elements = context.getDescriptorDocument().getRootElement().elements("component");
            ValidationPattern validation = ValidationPattern.createPattern().rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@key").withError("The key is required"), ValidationPattern.test((String)"@class").withError("The class is required"), ValidationPattern.test((String)"not(@public) or interface").withError("Interfaces must be declared for public components")});
            for (Element component : elements) {
                if (!PluginUtils.doesModuleElementApplyToApplication((Element)component, context.getApplicationKeys())) continue;
                validation.evaluate((Node)component);
                Element bean = root.addElement("beans:bean");
                bean.addAttribute("id", component.attributeValue("key"));
                bean.addAttribute("alias", component.attributeValue("alias"));
                bean.addAttribute("class", component.attributeValue("class"));
                if (!"true".equalsIgnoreCase(component.attributeValue("public"))) continue;
                Element osgiService = root.addElement("osgi:service");
                osgiService.addAttribute("id", component.attributeValue("key") + "_osgiService");
                osgiService.addAttribute("ref", component.attributeValue("key"));
                ArrayList<String> interfaceNames = new ArrayList<String>();
                List compInterfaces = component.elements("interface");
                for (Element inf : compInterfaces) {
                    interfaceNames.add(inf.getTextTrim());
                }
                Element interfaces = osgiService.addElement("osgi:interfaces");
                for (String name : interfaceNames) {
                    this.ensureExported(name, context);
                    Element e = interfaces.addElement("beans:value");
                    e.setText(name);
                }
            }
            if (root.elements().size() > 0) {
                context.setShouldRequireSpring(true);
                context.getFileOverrides().put(SPRING_XML, SpringHelper.documentToBytes(springDoc));
            }
        }
    }

    void ensureExported(String className, TransformContext context) {
        String pkg = className.substring(0, className.lastIndexOf(46));
        if (!context.getExtraExports().contains(pkg)) {
            String fileName = className.replace('.', '/') + ".class";
            if (context.getPluginArtifact().doesResourceExist(fileName)) {
                context.getExtraExports().add(pkg);
            }
        }
    }
}

