/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.descriptors;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.springsecurity.DynamicProviderManager;
import com.atlassian.crowd.integration.springsecurity.RequestToApplicationMapper;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.plugin.application.springsecurity.LocalCrowdAuthenticationProvider;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.providers.AuthenticationProvider;

public class CrowdApplicationModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware,
ApplicationContextAware {
    private static final Logger logger = Logger.getLogger(CrowdApplicationModuleDescriptor.class);
    private static final PasswordCredential credential = new PasswordCredential("plugin-password");
    private ApplicationContext applicationContext;
    private ApplicationManager applicationManager;
    private ApplicationService applicationService;
    private DirectoryManager directoryManager;
    private DynamicProviderManager authenticationManager;
    private RequestToApplicationMapper requestToApplicationMapper;
    private String applicationName;
    private String applicationDescription;
    private String securePath;
    private LocalCrowdAuthenticationProvider localProvider;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.applicationName = this.getKey();
        this.applicationDescription = this.getDescription();
        Element secureElt = element.element("secure");
        if (secureElt != null) {
            this.securePath = secureElt.getText();
        }
        if (StringUtils.isBlank((String)this.applicationName)) {
            throw new PluginParseException("The 'key' attribute is blank in the crowd-application module for plugin: " + plugin.getName());
        }
        if (StringUtils.isBlank((String)this.applicationDescription)) {
            throw new PluginParseException("The 'description' element is blank in the crowd-application module for plugin: " + plugin.getName());
        }
        if (StringUtils.isBlank((String)this.securePath)) {
            throw new PluginParseException("The 'secure' element is blank in the crowd-application module for plugin: " + plugin.getName());
        }
    }

    public Object getModule() {
        if (this.localProvider == null) {
            try {
                Application application = this.applicationManager.findByName(this.applicationName);
                this.localProvider = new LocalCrowdAuthenticationProvider(application, this.applicationService, this.applicationManager, this.directoryManager);
            }
            catch (ObjectNotFoundException e) {
                String msg = "Could not find application with name: " + this.applicationName + " for plugin " + this.plugin.getName();
                throw new IllegalStateException(msg, e);
            }
        }
        return this.localProvider;
    }

    public void enabled() {
        super.enabled();
        try {
            Application existingApp = this.applicationManager.findByName(this.applicationName);
            if (existingApp.getType() != ApplicationType.PLUGIN) {
                String msg = "Application with name " + this.applicationName + " exists but is not a plugin. Remove this application and restart Crowd to enable plugin: " + this.plugin.getName();
                throw new IllegalStateException(msg);
            }
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)("Adding application '" + this.applicationName + "' to Crowd for plugin: " + this.plugin.getName()));
            Application app = new Application(this.applicationName, ApplicationType.PLUGIN, credential);
            app.setDescription(this.applicationDescription);
            try {
                app = this.applicationManager.add(app);
            }
            catch (Exception e1) {
                String msg = "Unable to add application '" + this.applicationName + "' to Crowd for plugin: " + this.plugin.getName();
                throw new RuntimeException(msg, e1);
            }
        }
        this.authenticationManager.addProvider((AuthenticationProvider)this.getModule());
        this.requestToApplicationMapper.addSecureMapping(this.securePath, this.applicationName);
    }

    public void disabled() {
        try {
            Application app = this.applicationManager.findByName(this.applicationName);
            app.setActive(false);
            this.applicationManager.update(app);
        }
        catch (ObjectNotFoundException e) {
        }
        catch (Exception e) {
            String msg = "Unable to deactive application '" + this.applicationName + "' in Crowd for plugin: " + this.plugin.getName();
            throw new RuntimeException(msg, e);
        }
        if (this.localProvider != null) {
            this.authenticationManager.removeProvider((AuthenticationProvider)this.getModule());
        }
        this.requestToApplicationMapper.removeSecureMapping(this.securePath);
        this.localProvider = null;
        super.disabled();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setAuthenticationManager(DynamicProviderManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setRequestToApplicationMapper(RequestToApplicationMapper requestToApplicationMapper) {
        this.requestToApplicationMapper = requestToApplicationMapper;
    }
}

