/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.application.springsecurity;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.service.soap.ObjectTranslator;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.springsecurity.CrowdAuthenticationProvider;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdDataAccessException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class LocalCrowdAuthenticationProvider
extends CrowdAuthenticationProvider {
    private static final Log logger = LogFactory.getLog(LocalCrowdAuthenticationProvider.class);
    private static final String ROLE_PREFIX = "ROLE_";
    private final ApplicationManager applicationManager;
    private final ApplicationService applicationService;
    private final DirectoryManager directoryManager;

    public LocalCrowdAuthenticationProvider(Application application, ApplicationService applicationService, ApplicationManager applicationManager, DirectoryManager directoryManager) {
        super(application.getName());
        this.applicationService = applicationService;
        this.applicationManager = applicationManager;
        this.directoryManager = directoryManager;
    }

    protected boolean isAuthenticated(String token, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, RemoteException {
        try {
            this.applicationService.validateUserToken(token, validationFactors, this.applicationName);
            return true;
        }
        catch (InvalidTokenException e) {
            return false;
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            throw new ApplicationAccessDeniedException((Throwable)e);
        }
        catch (DirectoryAccessException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    protected String authenticate(String username, String password, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, RemoteException {
        UserAuthenticationContext pac = new UserAuthenticationContext();
        pac.setName(username);
        pac.setCredential(new PasswordCredential(password));
        pac.setApplication(this.applicationName);
        pac.setValidationFactors(validationFactors);
        try {
            Token token = this.applicationService.authenticateUser(pac);
            return token.getRandomHash();
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            throw new ApplicationAccessDeniedException((Throwable)e);
        }
        catch (DirectoryAccessException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    protected CrowdUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            Application application = this.getApplication();
            SOAPPrincipal principal = ObjectTranslator.processUser((User)this.applicationService.findUserByName(application, username), (boolean)application.isLowerCaseOutput());
            return new CrowdUserDetails(principal, this.findGrantedAuthorities(principal.getName()));
        }
        catch (DirectoryAccessException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (ObjectNotFoundException e) {
            throw new UsernameNotFoundException("User " + username + " not found under application: " + this.applicationName, (Throwable)e);
        }
    }

    protected CrowdUserDetails loadUserByToken(String token) throws CrowdSSOTokenInvalidException, DataAccessException {
        try {
            SOAPPrincipal principal = ObjectTranslator.processUser((User)this.directoryManager.findUserByToken(token), (boolean)this.isLowerCaseOutput());
            return new CrowdUserDetails(principal, this.findGrantedAuthorities(principal.getName()));
        }
        catch (DirectoryAccessException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (InvalidTokenException e) {
            throw new CrowdSSOTokenInvalidException("Invalid token: " + token, (Throwable)e);
        }
    }

    private GrantedAuthority[] findGrantedAuthorities(String username) {
        ArrayList<GrantedAuthorityImpl> auths = new ArrayList<GrantedAuthorityImpl>();
        try {
            List groups = this.applicationService.searchNestedGroupRelationships(this.getApplication(), QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(username).returningAtMost(-1).asNames());
            for (String group : groups) {
                group = ObjectTranslator.processDirectoryEntityName((String)group, (boolean)this.isLowerCaseOutput());
                auths.add(new GrantedAuthorityImpl(ROLE_PREFIX + group));
            }
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)("Could not find group memberships for user " + username + " as application: " + this.applicationName), (Throwable)e);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)("Could not find group memberships for user " + username + " as application: " + this.applicationName), (Throwable)e);
        }
        return auths.toArray(new GrantedAuthority[auths.size()]);
    }

    protected boolean isLowerCaseOutput() {
        boolean forceLower = false;
        try {
            Application app = this.applicationManager.findByName(this.applicationName);
            forceLower = app.isLowerCaseOutput();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return forceLower;
    }

    protected Application getApplication() throws ObjectNotFoundException {
        return this.applicationManager.findByName(this.applicationName);
    }
}

