/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.soap;

import com.atlassian.crowd.integration.model.AttributeAware;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPEntity;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.integration.util.SOAPPrincipalHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTranslator {
    private static final Logger logger = Logger.getLogger(ObjectTranslator.class);

    public static SOAPGroup[] processSOAPGroupAndMemberNames(SOAPGroup[] groups, boolean forceLower) {
        for (SOAPGroup group : groups) {
            group.setName(ObjectTranslator.processDirectoryEntityName(group.getName(), forceLower));
            ArrayList<String> newMembers = new ArrayList<String>(group.getMembers().length);
            for (String member : group.getMembers()) {
                newMembers.add(ObjectTranslator.processDirectoryEntityName(member, forceLower));
            }
            group.setMembers(newMembers.toArray(new String[newMembers.size()]));
        }
        return groups;
    }

    public static SOAPNestableGroup[] processSOAPGroupAndMemberNames(SOAPNestableGroup[] groups, boolean forceLower) {
        for (SOAPNestableGroup group : groups) {
            group.setName(ObjectTranslator.processDirectoryEntityName(group.getName(), forceLower));
            ArrayList<String> newMembers = new ArrayList<String>(group.getGroupMembers().length);
            for (String member : group.getGroupMembers()) {
                newMembers.add(ObjectTranslator.processDirectoryEntityName(member, forceLower));
            }
            group.setGroupMembers(newMembers.toArray(new String[newMembers.size()]));
        }
        return groups;
    }

    public static SOAPRole[] processSOAPRoleAndMemberNames(SOAPRole[] roles, boolean forceLower) {
        for (SOAPRole role : roles) {
            role.setName(ObjectTranslator.processDirectoryEntityName(role.getName(), forceLower));
            ArrayList<String> newMembers = new ArrayList<String>(role.getMembers().length);
            for (String member : role.getMembers()) {
                newMembers.add(ObjectTranslator.processDirectoryEntityName(member, forceLower));
            }
            role.setMembers(newMembers.toArray(new String[newMembers.size()]));
        }
        return roles;
    }

    public static SOAPNestableGroup[] processSOAPNestableGroupAndMemberNames(Collection<SOAPNestableGroup> groups, boolean forceLower) {
        SOAPNestableGroup[] soapGroups = new SOAPNestableGroup[groups.size()];
        Iterator<SOAPNestableGroup> groupIt = groups.iterator();
        for (int ctr = 0; ctr < soapGroups.length && groupIt.hasNext(); ++ctr) {
            soapGroups[ctr] = ObjectTranslator.processNestableGroup(groupIt.next(), forceLower);
        }
        return soapGroups;
    }

    public static SOAPPrincipal[] processUsers(Collection<User> users, boolean forceLower) {
        SOAPPrincipal[] soapUsers = new SOAPPrincipal[users.size()];
        Iterator<User> userIt = users.iterator();
        for (int ctr = 0; ctr < soapUsers.length && userIt.hasNext(); ++ctr) {
            soapUsers[ctr] = ObjectTranslator.processUser(userIt.next(), forceLower);
        }
        return soapUsers;
    }

    public static SOAPGroup processGroup(Group group, List<String> nestedUserMembers, boolean forceLower) {
        SOAPGroup soapGroup = new SOAPGroup();
        ObjectTranslator.processDirectoryEntity((DirectoryEntity)group, (SOAPEntity)soapGroup, forceLower);
        soapGroup.setActive(group.isActive());
        soapGroup.setDescription(group.getDescription());
        ArrayList<String> memberNames = new ArrayList<String>(nestedUserMembers.size());
        for (String memberName : nestedUserMembers) {
            memberNames.add(ObjectTranslator.processDirectoryEntityName(memberName, forceLower));
        }
        soapGroup.setMembers(memberNames.toArray(new String[memberNames.size()]));
        soapGroup.setAttributes(new SOAPAttribute[0]);
        return soapGroup;
    }

    public static SOAPGroup processGroupWithAttributes(GroupWithAttributes group, List<String> nestedUserMembers, boolean forceLower) {
        SOAPGroup soapGroup = ObjectTranslator.processGroup((Group)group, nestedUserMembers, forceLower);
        ObjectTranslator.processSOAPEntityAttributes((AttributeAware)group, (SOAPEntity)soapGroup);
        return soapGroup;
    }

    public static SOAPNestableGroup processNestableGroup(SOAPNestableGroup group, boolean forceLower) {
        SOAPNestableGroup soapGroup = new SOAPNestableGroup();
        soapGroup.setName(ObjectTranslator.processDirectoryEntityName(group.getName(), forceLower));
        ArrayList<String> memberNames = new ArrayList<String>();
        for (String memberName : group.getGroupMembers()) {
            memberNames.add(ObjectTranslator.processDirectoryEntityName(memberName, forceLower));
        }
        soapGroup.setGroupMembers(memberNames.toArray(new String[memberNames.size()]));
        return soapGroup;
    }

    private static void appendSOAPAttribute(String name, String value, List<SOAPAttribute> soapAttributes) {
        if (name != null && value != null) {
            soapAttributes.add(new SOAPAttribute(name, value));
        }
    }

    private static void appendSOAPAttribute(String name, List<String> values, List<SOAPAttribute> soapAttributes) {
        if (name != null && values != null) {
            soapAttributes.add(new SOAPAttribute(name, values.toArray(new String[values.size()])));
        }
    }

    public static SOAPPrincipal processUser(User user, boolean forceLower) {
        SOAPPrincipal soapUser = new SOAPPrincipal();
        ObjectTranslator.processDirectoryEntity((DirectoryEntity)user, (SOAPEntity)soapUser, forceLower);
        soapUser.setActive(user.isActive());
        ArrayList<SOAPAttribute> soapAttributes = new ArrayList<SOAPAttribute>();
        ObjectTranslator.appendSOAPAttribute("givenName", user.getFirstName(), soapAttributes);
        ObjectTranslator.appendSOAPAttribute("sn", user.getLastName(), soapAttributes);
        ObjectTranslator.appendSOAPAttribute("displayName", user.getDisplayName(), soapAttributes);
        ObjectTranslator.appendSOAPAttribute("mail", user.getEmailAddress(), soapAttributes);
        ObjectTranslator.appendSOAPAttribute("iconLocation", user.getIconLocation(), soapAttributes);
        soapUser.setAttributes(soapAttributes.toArray(new SOAPAttribute[soapAttributes.size()]));
        return soapUser;
    }

    public static SOAPPrincipal processUserWithAttributes(UserWithAttributes user, boolean forceLower) {
        SOAPPrincipal soapUser = ObjectTranslator.processUser((User)user, forceLower);
        ObjectTranslator.processSOAPEntityAttributes((AttributeAware)user, (SOAPEntity)soapUser);
        return soapUser;
    }

    public static UserTemplate processUser(SOAPPrincipal soapUser) {
        SOAPPrincipalHelper helper = new SOAPPrincipalHelper();
        UserTemplate user = new UserTemplate(soapUser.getName(), soapUser.getDirectoryId());
        user.setActive(soapUser.isActive());
        user.setFirstName(helper.getFirstName(soapUser));
        user.setLastName(helper.getLastName(soapUser));
        user.setDisplayName(helper.getFullName(soapUser));
        user.setEmailAddress(helper.getEmail(soapUser));
        user.setIconLocation(helper.getIconLocation(soapUser));
        return user;
    }

    public static SOAPRole processRole(Group role, List<String> directMemberNames, boolean forceLower) {
        SOAPRole soapRole = new SOAPRole();
        soapRole.setName(ObjectTranslator.processDirectoryEntityName(role.getName(), forceLower));
        soapRole.setDirectoryId(role.getDirectoryId().longValue());
        soapRole.setActive(role.isActive());
        soapRole.setDescription(role.getDescription());
        ArrayList<String> memberNames = new ArrayList<String>(directMemberNames.size());
        for (String memberName : directMemberNames) {
            memberNames.add(ObjectTranslator.processDirectoryEntityName(memberName, forceLower));
        }
        soapRole.setMembers(memberNames.toArray(new String[memberNames.size()]));
        return soapRole;
    }

    public static GroupTemplate processGroup(SOAPGroup soapGroup) {
        GroupTemplate group = new GroupTemplate(soapGroup.getName(), soapGroup.getDirectoryId(), GroupType.GROUP);
        group.setActive(soapGroup.isActive());
        group.setDescription(soapGroup.getDescription());
        return group;
    }

    public static GroupTemplate processRole(SOAPRole soapRole) {
        GroupTemplate group = new GroupTemplate(soapRole.getName(), soapRole.getDirectoryId(), GroupType.LEGACY_ROLE);
        group.setActive(soapRole.isActive());
        group.setDescription(soapRole.getDescription());
        return group;
    }

    private static void processDirectoryEntity(DirectoryEntity directoryEntity, SOAPEntity soapEntity, boolean forceLower) {
        soapEntity.setName(ObjectTranslator.processDirectoryEntityName(directoryEntity.getName(), forceLower));
        soapEntity.setDirectoryId(directoryEntity.getDirectoryId().longValue());
    }

    public static String processDirectoryEntityName(String name, boolean forceLower) {
        if (forceLower) {
            return name.toLowerCase();
        }
        return name;
    }

    public static List<String> processDirectoryEntityNames(Collection<String> names, boolean forceLower) {
        ArrayList<String> newNames = new ArrayList<String>(names.size());
        for (String name : names) {
            newNames.add(ObjectTranslator.processDirectoryEntityName(name, forceLower));
        }
        return newNames;
    }

    private static void processSOAPEntityAttributes(AttributeAware entity, SOAPEntity soapEntity) {
        ArrayList<SOAPAttribute> soapAttributes = new ArrayList<SOAPAttribute>();
        soapAttributes.addAll(Arrays.asList(soapEntity.getAttributes()));
        for (String attribute : entity.getAttributeNames()) {
            ObjectTranslator.appendSOAPAttribute(attribute, entity.getAttributes(attribute), soapAttributes);
        }
        soapEntity.setAttributes(soapAttributes.toArray(new SOAPAttribute[soapAttributes.size()]));
    }
}

