/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.XWorkConverter;
import java.util.HashSet;
import java.util.Set;

public class TextParseUtil {
    private static final int MAX_RECURSION = 1;

    public static String translateVariables(String expression, OgnlValueStack stack) {
        return TextParseUtil.translateVariables('$', expression, stack, String.class, null).toString();
    }

    public static String translateVariables(String expression, OgnlValueStack stack, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariables('$', expression, stack, String.class, evaluator).toString();
    }

    public static String translateVariables(char open, String expression, OgnlValueStack stack) {
        return TextParseUtil.translateVariables(open, expression, stack, String.class, null).toString();
    }

    public static Object translateVariables(char open, String expression, OgnlValueStack stack, Class asType) {
        return TextParseUtil.translateVariables(open, expression, stack, asType, null);
    }

    public static Object translateVariables(char open, String expression, OgnlValueStack stack, Class asType, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariables(open, expression, stack, asType, evaluator, 1);
    }

    public static Object translateVariables(char open, String expression, OgnlValueStack stack, Class asType, ParsedValueEvaluator evaluator, int maxLoopCount) {
        Object result = expression;
        int loopCount = 1;
        int pos = 0;
        while (true) {
            int start;
            if ((start = expression.indexOf(open + "{", pos)) == -1) {
                pos = 0;
                ++loopCount;
                start = expression.indexOf(open + "{");
            }
            if (loopCount > maxLoopCount) break;
            int length = expression.length();
            int x = start + 2;
            int count = 1;
            while (start != -1 && x < length && count != 0) {
                char c;
                if ((c = expression.charAt(x++)) == '{') {
                    ++count;
                    continue;
                }
                if (c != '}') continue;
                --count;
            }
            int end = x - 1;
            if (start == -1 || end == -1 || count != 0) break;
            String var = expression.substring(start + 2, end);
            Object o = stack.findValue(var, asType);
            if (evaluator != null) {
                o = evaluator.evaluate(o);
            }
            String left = expression.substring(0, start);
            String right = expression.substring(end + 1);
            String middle = null;
            if (o != null) {
                middle = o.toString();
                result = !TextUtils.stringSet((String)left) ? o : left + middle;
                if (TextUtils.stringSet((String)right)) {
                    result = result + right;
                }
                expression = left + middle + right;
            } else {
                result = left + right;
                expression = left + right;
            }
            pos = (left != null && left.length() > 0 ? left.length() - 1 : 0) + (middle != null && middle.length() > 0 ? middle.length() - 1 : 0) + 1;
            pos = Math.max(pos, 1);
        }
        return XWorkConverter.getInstance().convertValue(stack.getContext(), result, asType);
    }

    public static Set commaDelimitedStringToSet(String s) {
        HashSet<String> set = new HashSet<String>();
        String[] split = s.split(",");
        for (int i = 0; i < split.length; ++i) {
            String trimmed = split[i].trim();
            if (trimmed.length() <= 0) continue;
            set.add(trimmed);
        }
        return set;
    }

    public static interface ParsedValueEvaluator {
        public Object evaluate(Object var1);
    }
}

