/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.springframework.remoting.caucho.HessianExporter;
import org.springframework.util.FileCopyUtils;

public class SimpleHessianServiceExporter
extends HessianExporter
implements HttpHandler {
    public void handle(HttpExchange exchange) throws IOException {
        if (!"POST".equals(exchange.getRequestMethod())) {
            throw new IOException("SimpleHessianServiceExporter only supports POST requests");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        try {
            this.invoke(exchange.getRequestBody(), output);
        }
        catch (Throwable ex) {
            exchange.sendResponseHeaders(500, -1L);
            throw new IOException("Hessian skeleton invocation failed", ex);
        }
        exchange.sendResponseHeaders(200, output.size());
        FileCopyUtils.copy(output.toByteArray(), exchange.getResponseBody());
    }
}

