/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring;

import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.spring.AvailableToPlugins;
import org.apache.commons.lang.ClassUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component(value="hostComponentProvider")
public class SpringHostComponentProvider
implements HostComponentProvider,
BeanFactoryAware {
    private BeanFactory beanFactory = null;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void provide(ComponentRegistrar registrar) {
        if (this.beanFactory instanceof ListableBeanFactory) {
            String[] names;
            ListableBeanFactory lbf = (ListableBeanFactory)this.beanFactory;
            for (String name : names = lbf.getBeanDefinitionNames()) {
                try {
                    Object bean;
                    Class cls;
                    AvailableToPlugins annotation;
                    if (!lbf.isSingleton(name) || (annotation = (AvailableToPlugins)AnnotationUtils.findAnnotation((Class)(cls = AopUtils.getTargetClass((Object)(bean = lbf.getBean(name)))), AvailableToPlugins.class)) == null) continue;
                    Class[] ifs = annotation.value() != Void.class ? new Class[]{annotation.value()} : ClassUtils.getAllInterfaces(bean.getClass()).toArray(new Class[0]);
                    registrar.register(ifs).forInstance(bean).withName(name).withContextClassLoaderStrategy(annotation.contextClassLoaderStrategy());
                }
                catch (BeanIsAbstractException ex) {
                    // empty catch block
                }
            }
        }
    }
}

