/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor.listener;

import com.atlassian.crowd.integration.directory.monitor.listener.DirectoryListener;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorUnregistrationException;
import com.atlassian.crowd.manager.directory.monitor.listener.DirectoryListenerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DirectoryListenerManagerImpl
implements DirectoryListenerManager {
    private final Map<Long, DirectoryListener> directoryListeners = new HashMap<Long, DirectoryListener>();

    public void addListener(DirectoryListener listener) throws DirectoryMonitorRegistrationException {
        listener.startListening();
        this.directoryListeners.put(listener.getDirectoryID(), listener);
    }

    public boolean hasListener(long directoryID) {
        return this.directoryListeners.containsKey(directoryID);
    }

    public boolean removeListener(long directoryID) throws DirectoryMonitorUnregistrationException {
        DirectoryListener listener = this.directoryListeners.get(directoryID);
        if (listener != null) {
            listener.stopListening();
            this.directoryListeners.remove(directoryID);
            return true;
        }
        return false;
    }

    public void removeAllListeners() {
        ArrayList<Long> directoryIDs = new ArrayList<Long>(this.directoryListeners.keySet());
        for (Long directoryId : directoryIDs) {
            try {
                this.removeListener(directoryId);
            }
            catch (DirectoryMonitorUnregistrationException e) {}
        }
    }
}

