/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.event.TokenInvalidatedEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupAttributeDeletedEvent;
import com.atlassian.crowd.event.group.GroupAttributeStoredEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.ResetPasswordEvent;
import com.atlassian.crowd.event.user.UserAttributeDeletedEvent;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.PasswordHelper;
import com.atlassian.crowd.integration.directory.BatchingRemoteDirectory;
import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.DirectoryInstantiationException;
import com.atlassian.crowd.integration.exception.DirectoryPermissionException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidMembershipException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.MembershipNotFoundException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import com.atlassian.crowd.integration.model.membership.MembershipType;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.ApplicationDAO;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAO;
import com.atlassian.crowd.model.directory.OperationType;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenDAO;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.ReturnType;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.search.SearchResultsUtil;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryManagerGeneric
implements DirectoryManager {
    private static final int MILLIS_IN_MINUTE = 60000;
    private final Logger logger = Logger.getLogger(this.getClass());
    private DirectoryDAO directoryDAO;
    private ApplicationDAO applicationDAO;
    private TokenDAO tokenDAO;
    private EventManager eventManager;
    private PermissionManager permissionManager;
    private PasswordHelper passwordHelper;
    private PropertyManager propertyManager;
    private I18nHelper i18nHelper;

    public Directory addDirectory(Directory directory) throws DirectoryInstantiationException {
        directory.getRawImplementation();
        Directory addedDirectory = this.directoryDAO.add(directory);
        this.eventManager.publishEvent((Event)new DirectoryCreatedEvent((Object)this, directory));
        return addedDirectory;
    }

    public Directory findDirectoryById(long directoryId) throws ObjectNotFoundException {
        return this.directoryDAO.findById(directoryId);
    }

    public List<Directory> findAllDirectories() {
        return this.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
    }

    public List<Directory> searchDirectories(EntityQuery query) {
        return this.directoryDAO.search(query);
    }

    public Directory findDirectoryByName(String name) throws ObjectNotFoundException {
        return this.directoryDAO.findByName(name);
    }

    public Directory updateDirectory(Directory directory) throws ObjectNotFoundException {
        if (directory.getId() == null) {
            throw new ObjectNotFoundException(Directory.class, (Object)"null");
        }
        this.findDirectoryById(directory.getId());
        Directory updatedDirectory = this.directoryDAO.update(directory);
        this.eventManager.publishEvent((Event)new DirectoryUpdatedEvent((Object)this, updatedDirectory));
        return updatedDirectory;
    }

    public void removeDirectory(Directory directory) throws ObjectNotFoundException {
        this.applicationDAO.removeDirectoryMappings(directory.getId().longValue());
        this.tokenDAO.removeAll(directory.getId().longValue());
        this.directoryDAO.remove(directory);
        this.eventManager.publishEvent((Event)new DirectoryDeletedEvent((Object)this, directory));
    }

    public void invalidateToken(String tokenKey) {
        block3: {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("InvalidateToken: token " + tokenKey));
                }
                Token token = this.tokenDAO.findByRandomHash(tokenKey);
                this.logger.debug((Object)"Removing token from the database");
                this.tokenDAO.remove(token);
                this.eventManager.publishEvent((Event)new TokenInvalidatedEvent((Object)this, token));
            }
            catch (ObjectNotFoundException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)"Token does not exist", (Throwable)e);
            }
        }
    }

    public List<Token> searchTokens(EntityQuery query) {
        return this.tokenDAO.search(query);
    }

    public void removeExpiredTokens() {
        long expiration = this.propertyManager.getSessionTime();
        Date expiryTime = new Date(System.currentTimeMillis() - expiration * 60000L);
        this.tokenDAO.removeAccessedBefore(expiryTime);
    }

    public User findUserByToken(String key) throws InvalidTokenException, DirectoryAccessException {
        try {
            Token token = this.tokenDAO.findByRandomHash(key);
            if (token.isApplicationToken()) {
                throw new InvalidTokenException("Found token was for an application, not a user");
            }
            return this.findUserByName(token.getDirectoryId(), token.getName());
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidTokenException(e.getMessage(), (Throwable)e);
        }
    }

    private RemoteDirectory getDirectoryImplementation(long directoryId) throws DirectoryInstantiationException, ObjectNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        return directory.getImplementation();
    }

    public User findUserByName(long directoryId, String username) throws ObjectNotFoundException, DirectoryAccessException {
        return this.getDirectoryImplementation(directoryId).findUserByName(username);
    }

    public UserWithAttributes findUserWithAttributesByName(long directoryId, String username) throws ObjectNotFoundException, DirectoryAccessException {
        return this.getDirectoryImplementation(directoryId).findUserWithAttributesByName(username);
    }

    public List searchUsers(long directoryId, EntityQuery query) throws DirectoryAccessException, ObjectNotFoundException {
        return this.getDirectoryImplementation(directoryId).searchUsers(query);
    }

    public User addUser(long directoryId, UserTemplate user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException {
        try {
            this.findUserByName(directoryId, user.getName());
            throw new InvalidUserException((User)user, "User already exists");
        }
        catch (ObjectNotFoundException e) {
            Directory directory = this.findDirectoryById(directoryId);
            if (this.permissionManager.hasPermission(directory, OperationType.CREATE_USER)) {
                User createdUser = this.getDirectoryImplementation(directoryId).addUser(user, credential);
                this.eventManager.publishEvent((Event)new UserCreatedEvent((Object)this, directory, createdUser));
                return createdUser;
            }
            throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.add.principal"));
        }
    }

    public User updateUser(long directoryId, UserTemplate user) throws ObjectNotFoundException, DirectoryAccessException, DirectoryPermissionException, InvalidUserException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            User updatedUser = this.getDirectoryImplementation(directoryId).updateUser(user);
            this.eventManager.publishEvent((Event)new UserUpdatedEvent((Object)this, directory, updatedUser));
            return updatedUser;
        }
        throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.modify.principal"));
    }

    public User renameUser(long directoryId, String oldUsername, String newUsername) throws ObjectNotFoundException, DirectoryAccessException, DirectoryPermissionException, InvalidUserException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            User updatedUser = this.getDirectoryImplementation(directoryId).renameUser(oldUsername, newUsername);
            this.eventManager.publishEvent((Event)new UserUpdatedEvent((Object)this, directory, updatedUser));
            return updatedUser;
        }
        throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.modify.principal"));
    }

    public void storeUserAttributes(long directoryId, String username, Map<String, List<String>> attributes) throws DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.modify.principal"));
        }
        this.getDirectoryImplementation(directoryId).storeUserAttributes(username, attributes);
        User updatedUser = this.getDirectoryImplementation(directoryId).findUserByName(username);
        this.eventManager.publishEvent((Event)new UserAttributeStoredEvent((Object)this, directory, updatedUser, attributes));
    }

    public void removeUserAttributes(long directoryId, String username, String attributeName) throws DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.modify.principal"));
        }
        this.getDirectoryImplementation(directoryId).removeUserAttributes(username, attributeName);
        User updatedUser = this.getDirectoryImplementation(directoryId).findUserByName(username);
        this.eventManager.publishEvent((Event)new UserAttributeDeletedEvent((Object)this, directory, updatedUser, attributeName));
    }

    public void updateUserCredential(long directoryId, String username, PasswordCredential credential) throws DirectoryAccessException, DirectoryPermissionException, InvalidCredentialException, ObjectNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.modify.principal"));
        }
        this.getDirectoryImplementation(directoryId).updateUserCredential(username, credential);
        this.eventManager.publishEvent((Event)new UserCredentialUpdatedEvent((Object)this, directory, username, credential));
    }

    public void resetPassword(long directoryId, String username) throws ObjectNotFoundException, DirectoryAccessException, InvalidEmailAddressException, DirectoryPermissionException, InvalidCredentialException {
        User user;
        String password;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            password = this.passwordHelper.generateRandomPassword();
            PasswordCredential credential = new PasswordCredential(password);
            user = this.getDirectoryImplementation(directoryId).findUserByName(username);
            if (!StringUtils.isNotBlank((String)user.getEmailAddress())) {
                throw new InvalidEmailAddressException(this.i18nHelper.getText("principal.resetpassword.error.blank"));
            }
            this.getDirectoryImplementation(directoryId).updateUserCredential(username, credential);
        } else {
            throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.modify.principal"));
        }
        this.eventManager.publishEvent((Event)new ResetPasswordEvent((Object)this, directory, user, password));
    }

    public void removeUser(long directoryId, String username) throws ObjectNotFoundException, DirectoryPermissionException, DirectoryAccessException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.DELETE_USER)) {
            throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.remove.principal"));
        }
        this.getDirectoryImplementation(directoryId).removeUser(username);
        this.tokenDAO.remove(directoryId, username);
        this.eventManager.publishEvent((Event)new UserDeletedEvent((Object)this, directory, username));
    }

    public Group findGroupByName(long directoryId, String groupName) throws ObjectNotFoundException, DirectoryAccessException {
        return this.getDirectoryImplementation(directoryId).findGroupByName(groupName);
    }

    public GroupWithAttributes findGroupWithAttributesByName(long directoryId, String groupName) throws ObjectNotFoundException, DirectoryAccessException {
        return this.getDirectoryImplementation(directoryId).findGroupWithAttributesByName(groupName);
    }

    public List searchGroups(long directoryId, EntityQuery query) throws DirectoryAccessException, ObjectNotFoundException {
        return this.getDirectoryImplementation(directoryId).searchGroups(query);
    }

    public Group addGroup(long directoryId, GroupTemplate group) throws InvalidGroupException, DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        try {
            this.findGroupByName(directoryId, group.getName());
            throw new InvalidGroupException((Group)group, "Group with name <" + group.getName() + "> already exists in directory <" + directory.getName() + ">");
        }
        catch (ObjectNotFoundException e) {
            OperationType operationType;
            OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)group.getType()) ? OperationType.CREATE_GROUP : OperationType.CREATE_ROLE;
            if (!this.permissionManager.hasPermission(directory, operationType)) {
                String exceptionKey = OperationType.CREATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.add.group" : "permission.directory.exception.add.role";
                throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
            }
            Group createdGroup = this.getDirectoryImplementation(directoryId).addGroup(group);
            this.eventManager.publishEvent((Event)new GroupCreatedEvent((Object)this, directory, createdGroup));
            return createdGroup;
        }
    }

    public Group updateGroup(long directoryId, GroupTemplate group) throws ObjectNotFoundException, DirectoryAccessException, DirectoryPermissionException, InvalidGroupException {
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)group.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        if (!this.permissionManager.hasPermission(directory, operationType)) {
            String exceptionKey = OperationType.UPDATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.modify.group" : "permission.directory.exception.modify.role";
            throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
        }
        Group updatedGroup = this.getDirectoryImplementation(directoryId).updateGroup(group);
        this.eventManager.publishEvent((Event)new GroupUpdatedEvent((Object)this, directory, updatedGroup));
        return updatedGroup;
    }

    public Group renameGroup(long directoryId, String oldGroupname, String newGroupname) throws ObjectNotFoundException, DirectoryAccessException, DirectoryPermissionException, InvalidGroupException {
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        Group groupToUpdate = this.findGroupByName(directoryId, oldGroupname);
        OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        if (this.permissionManager.hasPermission(directory, operationType)) {
            Group updatedGroup = this.getDirectoryImplementation(directoryId).renameGroup(oldGroupname, newGroupname);
            this.eventManager.publishEvent((Event)new GroupUpdatedEvent((Object)this, directory, updatedGroup));
            return updatedGroup;
        }
        String exceptionKey = OperationType.UPDATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.modify.group" : "permission.directory.exception.modify.role";
        throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
    }

    public void storeGroupAttributes(long directoryId, String groupName, Map<String, List<String>> attributes) throws DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException {
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        Group groupToUpdate = this.findGroupByName(directoryId, groupName);
        OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        if (!this.permissionManager.hasPermission(directory, operationType)) {
            String exceptionKey = OperationType.UPDATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.modify.group" : "permission.directory.exception.modify.role";
            throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
        }
        this.getDirectoryImplementation(directoryId).storeGroupAttributes(groupName, attributes);
        Group updateGroup = this.getDirectoryImplementation(directoryId).findGroupByName(groupName);
        this.eventManager.publishEvent((Event)new GroupAttributeStoredEvent((Object)this, directory, updateGroup, attributes));
    }

    public void removeGroupAttributes(long directoryId, String groupName, String attributeName) throws DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException {
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        Group groupToUpdate = this.findGroupByName(directoryId, groupName);
        OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        if (!this.permissionManager.hasPermission(directory, operationType)) {
            String exceptionKey = OperationType.UPDATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.modify.group" : "permission.directory.exception.modify.role";
            throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
        }
        this.getDirectoryImplementation(directoryId).removeGroupAttributes(groupName, attributeName);
        Group updateGroup = this.getDirectoryImplementation(directoryId).findGroupByName(groupName);
        this.eventManager.publishEvent((Event)new GroupAttributeDeletedEvent((Object)this, directory, updateGroup, attributeName));
    }

    public void removeGroup(long directoryId, String groupName) throws ObjectNotFoundException, DirectoryPermissionException, DirectoryAccessException {
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        Group groupToDelete = this.findGroupByName(directoryId, groupName);
        OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)groupToDelete.getType()) ? OperationType.DELETE_GROUP : OperationType.DELETE_ROLE;
        if (!this.permissionManager.hasPermission(directory, operationType)) {
            String exceptionKey = OperationType.DELETE_GROUP.equals((Object)operationType) ? "permission.directory.exception.remove.group" : "permission.directory.exception.remove.role";
            throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
        }
        this.getDirectoryImplementation(directoryId).removeGroup(groupName);
        this.applicationDAO.removeGroupMappings(directoryId, groupName);
        this.eventManager.publishEvent((Event)new GroupDeletedEvent((Object)this, directory, groupName));
    }

    public boolean isUserDirectGroupMember(long directoryId, String username, String groupName) throws ObjectNotFoundException, DirectoryAccessException {
        return this.getDirectoryImplementation(directoryId).isUserDirectGroupMember(username, groupName);
    }

    public boolean isGroupDirectGroupMember(long directoryId, String childGroup, String parentGroup) throws ObjectNotFoundException, DirectoryAccessException {
        if (childGroup.equals(parentGroup)) {
            return false;
        }
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            return false;
        }
        return remoteDirectory.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, ObjectNotFoundException, DirectoryAccessException {
        if (!this.isUserDirectGroupMember(directoryId, username, groupName)) {
            OperationType operationType;
            Directory directory = this.findDirectoryById(directoryId);
            Group groupToUpdate = this.findGroupByName(directoryId, groupName);
            OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
            if (this.permissionManager.hasPermission(directory, operationType)) {
                this.getDirectoryImplementation(directoryId).addUserToGroup(username, groupName);
                this.eventManager.publishEvent((Event)new GroupMembershipCreatedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
            } else {
                String exceptionKey = OperationType.UPDATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.modify.group" : "permission.directory.exception.modify.role";
                throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
            }
        }
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, ObjectNotFoundException, DirectoryAccessException, InvalidMembershipException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            throw new UnsupportedOperationException("Directory with id [" + directoryId + "] does not support nested groups");
        }
        if (!this.isGroupDirectGroupMember(directoryId, childGroup, parentGroup)) {
            OperationType operationType;
            Directory directory = this.findDirectoryById(directoryId);
            Group parentGroupToUpdate = this.findGroupByName(directoryId, parentGroup);
            OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)parentGroupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
            if (this.permissionManager.hasPermission(directory, operationType)) {
                if (childGroup.equals(parentGroup)) {
                    throw new InvalidMembershipException("Cannot add direct circular group membership reference");
                }
                remoteDirectory.addGroupToGroup(childGroup, parentGroup);
                this.eventManager.publishEvent((Event)new GroupMembershipCreatedEvent((Object)this, directory, childGroup, parentGroup, MembershipType.GROUP_GROUP));
            } else {
                String exceptionKey = OperationType.UPDATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.modify.group" : "permission.directory.exception.modify.role";
                throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
            }
        }
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, ObjectNotFoundException, DirectoryAccessException, MembershipNotFoundException {
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        Group groupToUpdate = this.findGroupByName(directoryId, groupName);
        OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        if (!this.permissionManager.hasPermission(directory, operationType)) {
            String exceptionKey = OperationType.UPDATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.modify.group" : "permission.directory.exception.modify.role";
            throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
        }
        this.getDirectoryImplementation(directoryId).removeUserFromGroup(username, groupName);
        this.eventManager.publishEvent((Event)new GroupMembershipDeletedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, ObjectNotFoundException, DirectoryAccessException, InvalidMembershipException, MembershipNotFoundException {
        OperationType operationType;
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            throw new UnsupportedOperationException("Directory with id [" + directoryId + "] does not support nested groups");
        }
        Directory directory = this.findDirectoryById(directoryId);
        Group groupToUpdate = this.findGroupByName(directoryId, parentGroup);
        OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        if (this.permissionManager.hasPermission(directory, operationType)) {
            if (childGroup.equals(parentGroup)) {
                throw new InvalidMembershipException("Cannot remove direct circular group membership reference");
            }
        } else {
            String exceptionKey = OperationType.UPDATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.modify.group" : "permission.directory.exception.modify.role";
            throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
        }
        remoteDirectory.removeGroupFromGroup(childGroup, parentGroup);
        this.eventManager.publishEvent((Event)new GroupMembershipDeletedEvent((Object)this, directory, childGroup, parentGroup, MembershipType.GROUP_GROUP));
    }

    public List searchDirectGroupRelationships(long directoryId, MembershipQuery query) throws ObjectNotFoundException, DirectoryAccessException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups() && query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            return Collections.emptyList();
        }
        return this.getDirectoryImplementation(directoryId).searchGroupRelationships(query);
    }

    public boolean isUserNestedGroupMember(long directoryId, String username, String groupName) throws ObjectNotFoundException, DirectoryAccessException {
        if (this.getDirectoryImplementation(directoryId).supportsNestedGroups()) {
            return this.isUserNestedGroupMember(directoryId, username, groupName, new HashSet<String>());
        }
        return this.isUserDirectGroupMember(directoryId, username, groupName);
    }

    private boolean isUserNestedGroupMember(long directoryId, String username, String groupName, Set<String> visitedGroups) throws ObjectNotFoundException, DirectoryAccessException {
        boolean isMember;
        block2: {
            Group childGroup;
            if (visitedGroups.contains(groupName.toLowerCase())) {
                return false;
            }
            isMember = this.isUserDirectGroupMember(directoryId, username, groupName);
            visitedGroups.add(groupName.toLowerCase());
            if (isMember) break block2;
            List subGroups = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group()).membersOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
            Iterator i$ = subGroups.iterator();
            while (i$.hasNext() && !(isMember = this.isUserNestedGroupMember(directoryId, username, (childGroup = (Group)i$.next()).getName(), visitedGroups))) {
            }
        }
        return isMember;
    }

    public boolean isGroupNestedGroupMember(long directoryId, String childGroup, String parentGroup) throws ObjectNotFoundException, DirectoryAccessException {
        if (childGroup.equals(parentGroup)) {
            return false;
        }
        if (this.getDirectoryImplementation(directoryId).supportsNestedGroups()) {
            return this.isGroupNestedGroupMember(directoryId, childGroup, parentGroup, new HashSet<String>());
        }
        return this.isGroupDirectGroupMember(directoryId, childGroup, parentGroup);
    }

    private boolean isGroupNestedGroupMember(long directoryId, String childGroupName, String parentGroupName, Set<String> visitedGroups) throws ObjectNotFoundException, DirectoryAccessException {
        boolean isMember;
        block2: {
            Group childGroup;
            if (visitedGroups.contains(parentGroupName.toLowerCase())) {
                return false;
            }
            isMember = this.isGroupDirectGroupMember(directoryId, childGroupName, parentGroupName);
            visitedGroups.add(parentGroupName.toLowerCase());
            if (isMember) break block2;
            List subGroups = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group()).membersOf(EntityDescriptor.group()).withName(parentGroupName).returningAtMost(-1));
            Iterator i$ = subGroups.iterator();
            while (i$.hasNext() && !(isMember = this.isGroupNestedGroupMember(directoryId, childGroupName, (childGroup = (Group)i$.next()).getName(), visitedGroups))) {
            }
        }
        return isMember;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List searchNestedGroupRelationships(long directoryId, MembershipQuery query) throws ObjectNotFoundException, DirectoryAccessException {
        List<User> relations;
        if (!this.getDirectoryImplementation(directoryId).supportsNestedGroups()) return this.searchDirectGroupRelationships(directoryId, query);
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        if (query.isFindMembers()) {
            if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
            if (query.getEntityToReturn().getEntityType() == Entity.USER) {
                relations = this.findNestedUserMembersOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
            } else {
                if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
                relations = this.findNestedGroupMembersOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
            }
        } else {
            if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
            if (query.getEntityToMatch().getEntityType() == Entity.USER) {
                relations = this.findNestedGroupMembershipsOfUser(directoryId, query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
            } else {
                if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
                relations = this.findNestedGroupMembershipsOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
            }
        }
        relations = SearchResultsUtil.constrainResults(relations, query.getStartIndex(), query.getMaxResults());
        if (query.getReturnType() != ReturnType.NAME) return relations;
        return SearchResultsUtil.convertEntitiesToNames(relations);
    }

    private List<Group> findNestedGroupMembershipsOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws ObjectNotFoundException, DirectoryAccessException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (ObjectNotFoundException e) {
            return Collections.emptyList();
        }
        List<Group> nestedParents = this.findNestedGroupMembershipsIncludingGroups(directoryId, Arrays.asList(group), groupType, maxResults);
        nestedParents.remove(group);
        return new ArrayList<Group>(nestedParents);
    }

    private List<Group> findNestedGroupMembershipsIncludingGroups(long directoryId, List<Group> groups, GroupType groupType, int maxResults) throws ObjectNotFoundException, DirectoryAccessException {
        LinkedList<Group> groupsToVisit = new LinkedList<Group>();
        LinkedHashSet<Group> nestedParents = new LinkedHashSet<Group>();
        groupsToVisit.addAll(groups);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedParents.size() >= maxResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedParents.contains(groupToVisit)) continue;
            nestedParents.add(groupToVisit);
            List directParents = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).membershipsOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directParents);
        }
        return new ArrayList<Group>(nestedParents);
    }

    private List<Group> findNestedGroupMembershipsOfUser(long directoryId, String username, GroupType groupType, int maxResults) throws DirectoryAccessException, ObjectNotFoundException {
        List directGroupMemberships = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).membershipsOf(EntityDescriptor.user()).withName(username).returningAtMost(maxResults));
        return this.findNestedGroupMembershipsIncludingGroups(directoryId, directGroupMemberships, groupType, maxResults);
    }

    private List<Group> findNestedGroupMembersOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws ObjectNotFoundException, DirectoryAccessException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (ObjectNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Group> groupsToVisit = new LinkedList<Group>();
        LinkedHashSet<Group> nestedMembers = new LinkedHashSet<Group>();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedMembers.size() >= maxResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedMembers.contains(groupToVisit)) continue;
            nestedMembers.add(groupToVisit);
            List directMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).membersOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directMembers);
        }
        nestedMembers.remove(group);
        return new ArrayList<Group>(nestedMembers);
    }

    private List<User> findNestedUserMembersOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws ObjectNotFoundException, DirectoryAccessException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (ObjectNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Group> groupsToVisit = new LinkedList<Group>();
        LinkedHashSet<Group> nestedGroupMembers = new LinkedHashSet<Group>();
        LinkedHashSet nestedUserMembers = new LinkedHashSet();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedUserMembers.size() >= maxResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            List directUserMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            nestedUserMembers.addAll(directUserMembers);
            if (nestedGroupMembers.contains(groupToVisit)) continue;
            nestedGroupMembers.add(groupToVisit);
            List directGroupMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).membersOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directGroupMembers);
        }
        return new ArrayList<User>(nestedUserMembers);
    }

    public BulkAddResult<User> addAllUsers(long directoryId, Collection<UserTemplateWithCredentialAndAttributes> users, boolean overwrite) throws DirectoryPermissionException, DirectoryAccessException, ObjectNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.CREATE_USER)) {
            Collection<UserTemplateWithCredentialAndAttributes> failedEntities;
            RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
            ArrayList<UserTemplateWithCredentialAndAttributes> usersToAdd = new ArrayList<UserTemplateWithCredentialAndAttributes>();
            BulkAddResult result = new BulkAddResult((long)users.size(), overwrite);
            for (UserTemplateWithCredentialAndAttributes user : users) {
                try {
                    this.findUserByName(directoryId, user.getName());
                    if (overwrite) {
                        try {
                            this.logger.info((Object)("Removing existing user: " + user));
                            this.removeUser(directoryId, user.getName());
                            usersToAdd.add(user);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("Could not remove user for bulk import overwrite: " + user), (Throwable)e);
                            result.addExistingEntity((Object)user);
                        }
                        continue;
                    }
                    this.logger.info((Object)("User <" + user + "> already exists in directory. Skipping over this entity."));
                    result.addExistingEntity((Object)user);
                }
                catch (ObjectNotFoundException e) {
                    usersToAdd.add(user);
                }
            }
            Set uniqueUsersToAdd = this.retainUniqueEntities(usersToAdd);
            if (remoteDirectory instanceof BatchingRemoteDirectory) {
                failedEntities = ((BatchingRemoteDirectory)remoteDirectory).addAllUsers(uniqueUsersToAdd);
            } else {
                failedEntities = new ArrayList();
                for (UserTemplateWithCredentialAndAttributes user : uniqueUsersToAdd) {
                    try {
                        remoteDirectory.addUser((UserTemplate)user, user.getCredential());
                    }
                    catch (Exception e) {
                        failedEntities.add(user);
                    }
                }
            }
            result.addFailedEntities(failedEntities);
            return result;
        }
        throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.add.principal"));
    }

    private <T> Set<T> retainUniqueEntities(Collection<T> entities) {
        HashSet<T> uniqueEntities = new HashSet<T>(entities.size());
        for (T entity : entities) {
            boolean added;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Going to add: " + entity));
            }
            if (added = uniqueEntities.add(entity)) continue;
            this.logger.warn((Object)("Duplicate entity. Entity is already in the set of entities to bulk add: " + entity));
        }
        return uniqueEntities;
    }

    public BulkAddResult<Group> addAllGroups(long directoryId, Collection<GroupTemplate> groups, boolean overwrite) throws DirectoryPermissionException, DirectoryAccessException, ObjectNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.CREATE_GROUP)) {
            Collection<GroupTemplate> failedEntities;
            RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
            ArrayList<GroupTemplate> groupsToAdd = new ArrayList<GroupTemplate>();
            BulkAddResult result = new BulkAddResult((long)groups.size(), overwrite);
            for (GroupTemplate group : groups) {
                try {
                    this.findGroupByName(directoryId, group.getName());
                    if (overwrite) {
                        try {
                            this.logger.info((Object)("Removing existing group: " + group));
                            this.removeGroup(directoryId, group.getName());
                            groupsToAdd.add(group);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("Could not remove group for bulk import overwrite: " + group), (Throwable)e);
                            result.addExistingEntity((Object)group);
                        }
                        continue;
                    }
                    this.logger.info((Object)("Group <" + group + "> already exists in directory. Skipping over this entity."));
                    result.addExistingEntity((Object)group);
                }
                catch (ObjectNotFoundException e) {
                    groupsToAdd.add(group);
                }
            }
            Set uniqueGroupsToAdd = this.retainUniqueEntities(groupsToAdd);
            if (remoteDirectory instanceof BatchingRemoteDirectory) {
                failedEntities = ((BatchingRemoteDirectory)remoteDirectory).addAllGroups(uniqueGroupsToAdd);
            } else {
                failedEntities = new ArrayList();
                for (GroupTemplate group : uniqueGroupsToAdd) {
                    try {
                        remoteDirectory.addGroup(group);
                    }
                    catch (Exception e) {
                        failedEntities.add(group);
                    }
                }
            }
            result.addFailedEntities(failedEntities);
            return result;
        }
        throw new DirectoryPermissionException(this.i18nHelper.getText("permission.directory.exception.add.group"));
    }

    public BulkAddResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws DirectoryPermissionException, DirectoryAccessException, ObjectNotFoundException {
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        Group groupToUpdate = this.findGroupByName(directoryId, groupName);
        OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        if (this.permissionManager.hasPermission(directory, operationType)) {
            Collection<String> failedUsers;
            RemoteDirectory remoteDirectory = directory.getImplementation();
            Set<String> usersToAdd = this.retainUniqueEntities(userNames);
            BulkAddResult result = new BulkAddResult((long)userNames.size(), true);
            if (remoteDirectory instanceof BatchingRemoteDirectory) {
                failedUsers = ((BatchingRemoteDirectory)remoteDirectory).addAllUsersToGroup(usersToAdd, groupName);
            } else {
                failedUsers = new ArrayList();
                for (String username : usersToAdd) {
                    try {
                        this.addUserToGroup(directoryId, username, groupName);
                    }
                    catch (Exception e) {
                        failedUsers.add(username);
                    }
                }
            }
            result.addFailedEntities(failedUsers);
            return result;
        }
        String exceptionKey = OperationType.UPDATE_GROUP.equals((Object)operationType) ? "permission.directory.exception.modify.group" : "permission.directory.exception.modify.role";
        throw new DirectoryPermissionException(this.i18nHelper.getText(exceptionKey));
    }

    public void setTokenDAO(TokenDAO tokenDAO) {
        this.tokenDAO = tokenDAO;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public void setDirectoryDAO(DirectoryDAO directoryDAO) {
        this.directoryDAO = directoryDAO;
    }

    public void setApplicationDAO(ApplicationDAO applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setPasswordHelper(PasswordHelper passwordHelper) {
        this.passwordHelper = passwordHelper;
    }
}

