/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.monitor.poller;

import com.atlassian.crowd.event.monitor.poller.PollingFinishedEvent;
import com.atlassian.crowd.event.monitor.poller.PollingStartedEvent;
import com.atlassian.crowd.event.remote.group.ActiveDirectoryGroupDeletedEvent;
import com.atlassian.crowd.event.remote.group.RemoteGroupCreatedOrUpdatedEvent;
import com.atlassian.crowd.event.remote.principal.ActiveDirectoryUserDeletedEvent;
import com.atlassian.crowd.event.remote.principal.RemoteUserCreatedOrUpdatedEvent;
import com.atlassian.crowd.integration.directory.connector.MicrosoftActiveDirectory;
import com.atlassian.crowd.integration.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.integration.model.Tombstone;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import java.util.List;

public class USNChangedPoller
implements DirectoryPoller {
    private final MicrosoftActiveDirectory activeDirectory;
    private final EventManager eventManager;
    private final long pollingInterval;
    private long highestCommittedUSN = 0L;

    public USNChangedPoller(MicrosoftActiveDirectory activeDirectory, EventManager eventManager) {
        this.activeDirectory = activeDirectory;
        this.eventManager = eventManager;
        this.pollingInterval = activeDirectory.getAttributeAsLong("pollingInterval", 0L);
        if (this.pollingInterval <= 0L) {
            throw new IllegalArgumentException("RemoteDirectory does not specify a positive pollingInterval");
        }
        this.highestCommittedUSN = activeDirectory.fetchHighestCommittedUSN();
    }

    public synchronized void pollChanges() {
        this.eventManager.publishEvent((Event)new PollingStartedEvent((DirectoryPoller)this, this.activeDirectory.getDirectoryId()));
        long currentHighestCommittedUSN = this.activeDirectory.fetchHighestCommittedUSN();
        this.pollPrincipalChanges();
        this.pollGroupChanges();
        this.highestCommittedUSN = currentHighestCommittedUSN;
        this.eventManager.publishEvent((Event)new PollingFinishedEvent((DirectoryPoller)this, this.activeDirectory.getDirectoryId()));
    }

    public long getDirectoryID() {
        return this.activeDirectory.getDirectoryId();
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    protected void pollPrincipalChanges() {
        List<LDAPUserWithAttributes> updatedUsers = this.activeDirectory.findAddedOrUpdatedUsersSince(this.highestCommittedUSN);
        for (LDAPUserWithAttributes user : updatedUsers) {
            this.eventManager.publishEvent((Event)new RemoteUserCreatedOrUpdatedEvent((Object)this, this.activeDirectory.getDirectoryId(), (User)user));
        }
        List<Tombstone> tombstones = this.activeDirectory.findUserTombstonesSince(this.highestCommittedUSN);
        for (Tombstone tombstone : tombstones) {
            this.eventManager.publishEvent((Event)new ActiveDirectoryUserDeletedEvent((Object)this, this.activeDirectory.getDirectoryId(), tombstone));
        }
    }

    protected void pollGroupChanges() {
        List<LDAPGroupWithAttributes> updatedGroups = this.activeDirectory.findAddedOrUpdatedGroupsSince(this.highestCommittedUSN);
        for (LDAPGroupWithAttributes group : updatedGroups) {
            this.eventManager.publishEvent((Event)new RemoteGroupCreatedOrUpdatedEvent((Object)this, this.activeDirectory.getDirectoryId(), (Group)group));
        }
        List<Tombstone> tombstones = this.activeDirectory.findGroupTombstonesSince(this.highestCommittedUSN);
        for (Tombstone tombstone : tombstones) {
            this.eventManager.publishEvent((Event)new ActiveDirectoryGroupDeletedEvent((Object)this, this.activeDirectory.getDirectoryId(), tombstone));
        }
    }
}

