/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper.attribute.group;

import com.atlassian.crowd.integration.directory.connector.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.util.connector.DNStandardiser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.ldap.core.DirContextAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RFC4519MemberDnMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "memberDNs";
    private final String groupMemberAttribute;
    private final boolean relaxedDnStandardisation;

    public RFC4519MemberDnMapper(String groupMemberAttribute, boolean relaxedDnStandardisation) {
        this.groupMemberAttribute = groupMemberAttribute;
        this.relaxedDnStandardisation = relaxedDnStandardisation;
    }

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public List<String> getValues(DirContextAdapter ctx) throws Exception {
        String[] members = ctx.getStringAttributes(this.groupMemberAttribute);
        if (members != null) {
            ArrayList<String> standardDNs = new ArrayList<String>(members.length);
            for (String memberDN : members) {
                String dn = DNStandardiser.standardise(memberDN, !this.relaxedDnStandardisation);
                standardDNs.add(dn);
            }
            return standardDNs;
        }
        return Collections.emptyList();
    }
}

