/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.cache;

import com.atlassian.crowd.event.remote.ActiveDirectoryEntityDeletedEvent;
import com.atlassian.crowd.integration.directory.cache.LDAPDirectoryCache;
import com.atlassian.crowd.integration.directory.cache.model.EntityIdentifier;
import com.atlassian.crowd.integration.directory.cache.model.EntityType;
import com.atlassian.crowd.integration.model.LDAPDirectoryEntity;
import com.atlassian.crowd.integration.model.Tombstone;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.event.Event;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class MicrosoftActiveDirectoryCache
extends LDAPDirectoryCache {
    private static final String GUID_TO_ENTITY_IDENTIFIER_CACHE = "com.atlassian.crowd.integration.directory.caching-guid-identifier";
    private static final String ENTITY_IDENTIFIER_TO_GUID_CACHE = "com.atlassian.crowd.integration.directory.caching-identifier-guid";
    private static final String ENTITY_IDENTIFIER_TO_USNCHANGED_CACHE = "com.atlassian.crowd.integration.directory.caching-identifier-usnchanged";
    private final Cache guidEntityIdentifierCache = this.createAndConfigureCache("com.atlassian.crowd.integration.directory.caching-guid-identifier");
    private final Cache entityIdentifierGuidCache = this.createAndConfigureCache("com.atlassian.crowd.integration.directory.caching-identifier-guid");
    private final Cache entityIdentifierUSNChangedCache = this.createAndConfigureCache("com.atlassian.crowd.integration.directory.caching-identifier-usnchanged");

    public MicrosoftActiveDirectoryCache(long directoryID, CacheManager ehcacheManager, int maxElementsInMemoryPerSubCache) {
        super(directoryID, ehcacheManager, maxElementsInMemoryPerSubCache);
    }

    protected void doClear() {
        super.doClear();
        this.guidEntityIdentifierCache.removeAll();
        this.entityIdentifierGuidCache.removeAll();
        this.entityIdentifierUSNChangedCache.removeAll();
    }

    protected void doClose() {
        super.doClose();
        this.removeCache(GUID_TO_ENTITY_IDENTIFIER_CACHE);
        this.removeCache(ENTITY_IDENTIFIER_TO_GUID_CACHE);
        this.removeCache(ENTITY_IDENTIFIER_TO_USNCHANGED_CACHE);
    }

    protected String getGuidFromEntity(LDAPDirectoryEntity entity) {
        return this.getAttributeFromEntity(entity, "objectGUID");
    }

    protected Long getUsnChangedFromEntity(LDAPDirectoryEntity entity) {
        String value = this.getAttributeFromEntity(entity, "uSNChanged");
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Entity does not have a numeric uSNChanged value: " + value);
        }
    }

    protected String getAttributeFromEntity(LDAPDirectoryEntity entity, String key) {
        String value = entity.getAttribute(key);
        if (value == null) {
            throw new IllegalArgumentException("Entity does not have a " + key + ": " + entity.getName());
        }
        return value;
    }

    protected boolean isNewerThanCache(EntityIdentifier identifier, Long usnChanged) {
        Long cachedUsnChanged = this.getUSNChanged(identifier);
        return cachedUsnChanged == null || usnChanged > cachedUsnChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeUser(User user) {
        if (!(user instanceof LDAPUserWithAttributes)) throw new IllegalArgumentException("Can only store LDAPUserWithAttributes, not: " + user.getClass().getCanonicalName());
        LDAPUserWithAttributes ldapUser = (LDAPUserWithAttributes)user;
        this.lockWrite();
        try {
            EntityIdentifier identifier = new EntityIdentifier(EntityType.USER, ldapUser.getName());
            Long usnChanged = this.getUsnChangedFromEntity((LDAPDirectoryEntity)ldapUser);
            if (!this.isNewerThanCache(identifier, usnChanged)) return;
            super.storeUser((User)ldapUser);
            this.storeGUIDMapping(this.getGuidFromEntity((LDAPDirectoryEntity)ldapUser), identifier);
            this.storeUSNChanged(identifier, usnChanged);
            return;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeGroup(Group group) {
        if (!(group instanceof LDAPGroupWithAttributes)) throw new IllegalArgumentException("Can only store LDAPGroupWithAttributes, not: " + group.getClass().getCanonicalName());
        LDAPGroupWithAttributes ldapGroup = (LDAPGroupWithAttributes)group;
        this.lockWrite();
        try {
            EntityIdentifier identifier = new EntityIdentifier(EntityType.GROUP, ldapGroup.getName());
            Long usnChanged = this.getUsnChangedFromEntity((LDAPDirectoryEntity)ldapGroup);
            if (!this.isNewerThanCache(identifier, usnChanged)) return;
            super.storeGroup((Group)ldapGroup);
            this.storeGUIDMapping(this.getGuidFromEntity((LDAPDirectoryEntity)ldapGroup), identifier);
            this.storeUSNChanged(identifier, usnChanged);
            return;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String userName) {
        this.lockWrite();
        try {
            super.removeUser(userName);
            this.removeGUIDMapping(EntityType.USER, userName);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String groupName) {
        this.lockWrite();
        try {
            super.removeGroup(groupName);
            this.removeGUIDMapping(EntityType.GROUP, groupName);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntityByTombstone(Tombstone tombstone) {
        this.lockWrite();
        try {
            String guid = tombstone.getObjectGUID();
            EntityIdentifier identifier = this.getEntityIdentifier(guid);
            if (identifier != null && this.isNewerThanCache(identifier, tombstone.getUsnChanged())) {
                this.removeEntityByGUID(guid);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    protected void removeEntityByGUID(String guid) {
        EntityIdentifier identifier = this.getEntityIdentifier(guid);
        if (identifier != null) {
            switch (identifier.getType()) {
                case USER: {
                    this.removeUser(identifier.getName());
                    break;
                }
                case GROUP: {
                    this.removeGroup(identifier.getName());
                }
            }
        }
    }

    protected void storeGUIDMapping(String guid, EntityIdentifier identifier) {
        this.guidEntityIdentifierCache.put(new Element((Serializable)((Object)guid), (Serializable)identifier));
        this.entityIdentifierGuidCache.put(new Element((Serializable)identifier, (Serializable)((Object)guid)));
    }

    protected void removeGUIDMapping(EntityType type, String name) {
        EntityIdentifier identifier = new EntityIdentifier(type, name);
        String guid = this.getGUID(identifier);
        if (guid != null) {
            this.guidEntityIdentifierCache.remove((Serializable)((Object)guid));
            this.entityIdentifierGuidCache.remove((Serializable)identifier);
        }
    }

    protected void removeGUIDMapping(String guid) {
        EntityIdentifier identifier = this.getEntityIdentifier(guid);
        if (identifier != null) {
            this.guidEntityIdentifierCache.remove((Serializable)((Object)guid));
            this.entityIdentifierGuidCache.remove((Serializable)identifier);
        }
    }

    protected String getGUID(EntityIdentifier identifier) {
        return (String)this.getFromCache(identifier, this.entityIdentifierGuidCache);
    }

    protected EntityIdentifier getEntityIdentifier(String guid) {
        return (EntityIdentifier)this.getFromCache((Serializable)((Object)guid), this.guidEntityIdentifierCache);
    }

    protected void storeUSNChanged(EntityIdentifier identifier, Long usnChanged) {
        this.entityIdentifierUSNChangedCache.put(new Element((Serializable)identifier, (Serializable)usnChanged));
    }

    protected Long getUSNChanged(EntityIdentifier identifier) {
        return (Long)this.getFromCache(identifier, this.entityIdentifierUSNChangedCache);
    }

    protected boolean doHandleEvent(Event evt) {
        boolean handled = super.doHandleEvent(evt);
        if (!handled && evt instanceof ActiveDirectoryEntityDeletedEvent) {
            ActiveDirectoryEntityDeletedEvent event = (ActiveDirectoryEntityDeletedEvent)evt;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("ActiveDirectoryEntityDeletedEvent: " + event.getTombstone()));
            }
            this.removeEntityByTombstone(event.getTombstone());
            handled = true;
        }
        return handled;
    }
}

