/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.authentication;

import com.atlassian.crowd.authentication.TokenFactory;
import com.atlassian.crowd.authentication.TokenKeyGenerator;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.model.token.Token;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenFactoryImpl
implements TokenFactory {
    private final TokenKeyGenerator tokenKeyGenerator;
    private final Random randomNumberGenerator;

    public TokenFactoryImpl(TokenKeyGenerator tokenKeyGenerator, Random randomNumberGenerator) {
        this.tokenKeyGenerator = tokenKeyGenerator;
        this.randomNumberGenerator = randomNumberGenerator;
    }

    public Token create(long directoryID, String name, List<ValidationFactor> validationFactors) throws InvalidTokenException {
        return this.create(directoryID, name, validationFactors, this.createSecretValidationNumber());
    }

    public Token create(long directoryID, String name, List<ValidationFactor> validationFactors, long secretNumber) throws InvalidTokenException {
        String identifierHash = this.tokenKeyGenerator.generateKey(directoryID, name, validationFactors);
        validationFactors.add(new ValidationFactor("Random-Number", Long.toString(secretNumber)));
        String randomHash = this.tokenKeyGenerator.generateKey(directoryID, name, validationFactors);
        return new Token(directoryID, name, identifierHash, secretNumber, randomHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long createSecretValidationNumber() {
        long randomLong;
        Random random = this.randomNumberGenerator;
        synchronized (random) {
            randomLong = this.randomNumberGenerator.nextLong();
            if (randomLong < 0L) {
                randomLong *= -1L;
            }
        }
        return randomLong;
    }
}

