/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.lifecycle;

import com.atlassian.config.lifecycle.DefaultLifecycleContext;
import com.atlassian.config.lifecycle.LifecycleContext;
import com.atlassian.config.lifecycle.LifecycleItem;
import com.atlassian.config.lifecycle.LifecycleManager;
import com.atlassian.config.lifecycle.LifecyclePluginModuleDescriptor;
import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.config.lifecycle.events.ApplicationStoppedEvent;
import com.atlassian.config.lifecycle.events.ApplicationStoppingEvent;
import com.atlassian.event.EventManager;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.PluginManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class DefaultLifecycleManager
implements LifecycleManager {
    private static Logger log = Logger.getLogger((Class)LifecycleManager.class);
    private PluginManager pluginManager;
    private EventManager eventManager;

    public void startUp(ServletContext servletContext) {
        List moduleDescriptors = this.getLifecyclePluginModuleDescriptors();
        DefaultLifecycleContext context = new DefaultLifecycleContext(servletContext);
        LifecyclePluginModuleDescriptor descriptor = null;
        try {
            Iterator it = moduleDescriptors.iterator();
            while (it.hasNext()) {
                descriptor = (LifecyclePluginModuleDescriptor)it.next();
                LifecycleItem item = (LifecycleItem)descriptor.getModule();
                log.info((Object)("Starting: " + descriptor));
                item.startup(context);
            }
            this.eventManager.publishEvent((com.atlassian.event.Event)new ApplicationStartedEvent(this));
        }
        catch (Throwable t) {
            this.panicAndShutdown(t, context, descriptor);
        }
    }

    public void shutDown(ServletContext servletContext) {
        this.shutDown(servletContext, null);
    }

    private void panicAndShutdown(Throwable t, LifecycleContext context, LifecyclePluginModuleDescriptor descriptor) {
        String errorString = "Unable to start up Confluence. Fatal error during startup sequence: " + descriptor + " - " + t;
        log.fatal((Object)errorString, t);
        context.getAgentJohnson().addEvent(new Event(EventType.get((String)"startup"), errorString, "fatal"));
        this.shutDown(context.getServletContext(), descriptor.getCompleteKey());
    }

    private void shutDown(ServletContext servletContext, String startingPluginKey) {
        this.eventManager.publishEvent((com.atlassian.event.Event)new ApplicationStoppingEvent(this));
        List moduleDescriptors = this.getLifecyclePluginModuleDescriptors();
        Collections.reverse(moduleDescriptors);
        DefaultLifecycleContext context = new DefaultLifecycleContext(servletContext);
        boolean started = startingPluginKey == null;
        Iterator it = moduleDescriptors.iterator();
        while (it.hasNext()) {
            LifecyclePluginModuleDescriptor descriptor = (LifecyclePluginModuleDescriptor)it.next();
            if (!started) {
                if (!descriptor.getCompleteKey().equals(startingPluginKey)) continue;
                started = true;
            }
            log.info((Object)("Shutting down: " + descriptor));
            LifecycleItem item = (LifecycleItem)descriptor.getModule();
            try {
                item.shutdown(context);
            }
            catch (Throwable t) {
                log.error((Object)("Error running shutdown plugin: " + descriptor.getDescription() + " - " + t), t);
            }
        }
        this.eventManager.publishEvent((com.atlassian.event.Event)new ApplicationStoppedEvent(this));
    }

    private List getLifecyclePluginModuleDescriptors() {
        List modules = this.pluginManager.getEnabledModuleDescriptorsByClass(LifecyclePluginModuleDescriptor.class);
        Collections.sort(modules);
        return modules;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

