/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.encoder;

import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;
import com.atlassian.crowd.password.encoder.LdapPasswordEncoder;
import org.springframework.security.providers.encoding.Md5PasswordEncoder;

public class LdapMd5PasswordEncoder
extends Md5PasswordEncoder
implements InternalPasswordEncoder,
LdapPasswordEncoder {
    private boolean forceLowerCasePrefix = false;
    protected static final String MD5_PREFIX = "{MD5}";
    protected static final String MD5_PREFIX_LC = "{MD5}".toLowerCase();

    public LdapMd5PasswordEncoder() {
        this.setEncodeHashAsBase64(true);
    }

    public String encodePassword(String rawPass, Object salt) {
        String encodedPassword = super.encodePassword(rawPass, salt);
        String prefix = this.forceLowerCasePrefix ? MD5_PREFIX_LC : MD5_PREFIX;
        return prefix + encodedPassword;
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String encPassWithoutPrefix = encPass.startsWith(MD5_PREFIX) || encPass.startsWith(MD5_PREFIX_LC) ? encPass.substring(5) : encPass;
        return this.encodePassword(rawPass, salt).endsWith(encPassWithoutPrefix);
    }

    public String getKey() {
        return "md5";
    }

    public void setForceLowerCasePrefix(boolean forceLowerCasePrefix) {
        this.forceLowerCasePrefix = forceLowerCasePrefix;
    }
}

