/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.encoder;

import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;
import com.atlassian.user.security.password.PasswordEncryptor;

public class AtlassianSHA1PasswordEncoder
implements InternalPasswordEncoder {
    private PasswordEncryptor passwordEncryptor;
    public static final String ATLASSIAN_SHA1_KEY = "atlassian-sha1";

    public AtlassianSHA1PasswordEncoder() {
    }

    public AtlassianSHA1PasswordEncoder(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public String encodePassword(String password, Object salt) {
        return this.passwordEncryptor.encrypt(password);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        boolean valid = false;
        if (encPass != null && rawPass != null) {
            valid = encPass.equals(this.encodePassword(rawPass, salt));
        }
        return valid;
    }

    public String getKey() {
        return ATLASSIAN_SHA1_KEY;
    }

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }
}

