/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.servlet.filter;

import com.atlassian.core.filters.cache.AbstractCachingFilter;
import com.atlassian.core.filters.cache.CachingStrategy;
import com.opensymphony.util.TextUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CrowdCachingFilter
extends AbstractCachingFilter {
    private static final CachingStrategy[] strategies = new CachingStrategy[]{new NonCachableCachingStrategy()};

    protected CachingStrategy[] getCachingStrategies() {
        return strategies;
    }

    static class NonCachableCachingStrategy
    implements CachingStrategy {
        NonCachableCachingStrategy() {
        }

        public boolean matches(HttpServletRequest request) {
            String uri = TextUtils.noNull((String)request.getRequestURI());
            return uri.indexOf(".jsp") > 0 || uri.indexOf(".action") > 0;
        }

        public void setCachingHeaders(HttpServletResponse response) {
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
    }
}

