/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.application;

import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.alias.AliasDAO;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDAO;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDAOHibernate
extends HibernateDao
implements ApplicationDAO {
    private HQLQueryTranslater hqlQueryTranslater;
    private AliasDAO aliasDAO;

    @Override
    public Class getPersistentClass() {
        return Application.class;
    }

    public Application findById(long id) throws ObjectNotFoundException {
        return (Application)this.load(id);
    }

    public Application findByName(final String name) throws ObjectNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(ApplicationDAOHibernate.this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"lowerName", (Object)name.toLowerCase())).uniqueResult();
            }
        });
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)name);
        }
        return (Application)result;
    }

    public Application add(Application application) {
        application.setCreatedDateToNow();
        application.setUpdatedDateToNow();
        application.validate();
        super.save(application);
        return application;
    }

    public Application update(Application application) {
        application.setUpdatedDateToNow();
        application.validate();
        super.update(application);
        return application;
    }

    public void remove(Application application) {
        this.aliasDAO.removeAliases(application);
        super.remove(application);
    }

    public List<Application> search(final EntityQuery query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.APPLICATION) {
            throw new IllegalArgumentException("ApplicationDAO can only evaluate EntityQueries for Entity.APPLICATION");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = ApplicationDAOHibernate.this.hqlQueryTranslater.asHQL(query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator<Object> iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults(hibernateQuery.list());
            }
        });
    }

    public void removeDirectoryMappings(final long directoryId) {
        List applications = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("findApplicationsWithDirectoryMapping").setLong("directoryId", directoryId).list();
            }
        });
        for (Application application : applications) {
            application.removeDirectoryMapping(directoryId);
            this.update(application);
        }
    }

    public void removeGroupMappings(final long directoryId, final String groupName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeGroupMappings").setLong("directoryId", directoryId).setString("groupName", groupName).executeUpdate();
            }
        });
    }

    public void renameGroupMappings(final long directoryId, final String oldGroupName, final String newGroupName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("renameGroupMappings").setLong("directoryId", directoryId).setString("oldGroupName", oldGroupName).setString("newGroupName", newGroupName).executeUpdate();
            }
        });
    }

    public List<Application> findAuthorisedApplications(final long directoryId, final List<String> groupNames) {
        if (groupNames == null || groupNames.isEmpty()) {
            return this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    return session.getNamedQuery("findAuthorisedApplicationsWithoutGroupNames").setLong("directoryId", directoryId).list();
                }
            });
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("findAuthorisedApplications").setLong("directoryId", directoryId).setParameterList("groupNames", (Collection)groupNames).list();
            }
        });
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    public void setAliasDAO(AliasDAO aliasDAO) {
        this.aliasDAO = aliasDAO;
    }
}

