/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.permission;

import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDAO;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAO;
import com.atlassian.crowd.model.directory.OperationType;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class PermissionManagerImpl
implements PermissionManager {
    private static final Logger logger = Logger.getLogger(PermissionManagerImpl.class);
    private ApplicationDAO applicationDAO;
    private DirectoryDAO directoryDAO;

    public boolean hasPermission(Directory directory, OperationType operationType) {
        Validate.notNull((Object)directory, (String)"directory cannot be null");
        Validate.notNull((Object)operationType, (String)"operationType cannot be null");
        boolean permission = directory.getAllowedOperations().contains(operationType);
        if (!permission && logger.isDebugEnabled()) {
            logger.debug((Object)("Directory " + directory.getName() + " : Permission " + operationType.name() + " has been denied"));
        }
        return permission;
    }

    public boolean hasPermission(Application application, Directory directory, OperationType operationType) {
        DirectoryMapping mapping;
        Validate.notNull((Object)application, (String)"application cannot be null");
        Validate.notNull((Object)directory, (String)"directory cannot be null");
        Validate.notNull((Object)operationType, (String)"operationType cannot be null");
        boolean hasPermission = false;
        if (this.hasPermission(directory, operationType) && (mapping = application.getDirectoryMapping(directory.getId().longValue())) != null) {
            hasPermission = mapping.getAllowedOperations().contains(operationType);
        }
        return hasPermission;
    }

    public void removePermission(Directory directory, OperationType operationType) {
        Validate.notNull((Object)directory, (String)"directory cannot be null");
        Validate.notNull((Object)operationType, (String)"operationType cannot be null");
        directory.getAllowedOperations().remove(operationType);
        this.directoryDAO.save((Object)directory);
    }

    public void removePermission(Application application, Directory directory, OperationType operationType) {
        Validate.notNull((Object)application, (String)"application cannot be null");
        Validate.notNull((Object)directory, (String)"directory cannot be null");
        Validate.notNull((Object)operationType, (String)"operationType cannot be null");
        DirectoryMapping mapping = application.getDirectoryMapping(directory.getId().longValue());
        if (mapping != null) {
            mapping.getAllowedOperations().remove(operationType);
            this.applicationDAO.update(application);
        }
    }

    public void addPermission(Directory directory, OperationType operationType) {
        Validate.notNull((Object)directory, (String)"directory cannot be null");
        Validate.notNull((Object)operationType, (String)"operationType cannot be null");
        directory.getAllowedOperations().add(operationType);
        this.directoryDAO.save((Object)directory);
    }

    public void addPermission(Application application, Directory directory, OperationType operationType) {
        Validate.notNull((Object)application, (String)"application cannot be null");
        Validate.notNull((Object)directory, (String)"directory cannot be null");
        Validate.notNull((Object)operationType, (String)"operationType cannot be null");
        DirectoryMapping mapping = application.getDirectoryMapping(directory.getId().longValue());
        if (mapping != null) {
            mapping.getAllowedOperations().add(operationType);
            this.applicationDAO.update(application);
        }
    }

    public void setApplicationDAO(ApplicationDAO applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    public void setDirectoryDAO(DirectoryDAO directoryDAO) {
        this.directoryDAO = directoryDAO;
    }
}

