/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.license;

import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.license.LicenseResourceEntity;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManagerException;
import com.atlassian.crowd.manager.license.CrowdLicenseStore;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.util.build.BuildUtils;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.crowd.CrowdLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.extras.core.LicenseManagerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrowdLicenseManagerImpl
implements CrowdLicenseManager {
    private static final Logger log = Logger.getLogger(CrowdLicenseManagerImpl.class);
    private PropertyManager propertyManager;
    private ApplicationManager applicationManager;
    private DirectoryManager directoryManager;
    private CrowdLicenseStore licenseStore;

    public CrowdLicense getLicense() {
        return this.licenseStore.getLicense();
    }

    public CrowdLicense storeLicense(String license) {
        return this.licenseStore.storeLicense(license);
    }

    public boolean isLicenseValid() {
        return this.isLicenseValid(this.getLicense());
    }

    private boolean isSetupLicenseValid(CrowdLicense license) {
        if (license == null) {
            return false;
        }
        if (license.isExpired() && license.isGracePeriodExpired()) {
            log.fatal((Object)"License has expired.");
            return false;
        }
        return true;
    }

    public boolean isSetupLicenseKeyValid(String key) {
        try {
            return this.isSetupLicenseValid(CrowdLicenseManagerImpl.getCrowdLicense(CrowdLicenseManagerImpl.getAtlassianLicense(key)));
        }
        catch (LicenseException e) {
            log.error((Object)("Failed to validate license: " + e.getMessage()));
            return false;
        }
    }

    public boolean isLicenseValid(CrowdLicense license) {
        if (license == null) {
            return false;
        }
        if (license.isExpired() && license.isGracePeriodExpired()) {
            log.fatal((Object)"License has expired.");
            return false;
        }
        if (!license.isUnlimitedNumberOfUsers() && license.getMaximumNumberOfUsers() < this.propertyManager.getCurrentLicenseResourceTotal()) {
            log.fatal((Object)"License resource limit has been reached.");
            return false;
        }
        return true;
    }

    public boolean isLicenseKeyValid(String key) {
        try {
            return this.isLicenseValid(CrowdLicenseStore.getCrowdLicense(CrowdLicenseStore.getAtlassianLicense(key)));
        }
        catch (LicenseException e) {
            log.error((Object)("Failed to validate license: " + e.getMessage()));
            return false;
        }
    }

    private static AtlassianLicense getAtlassianLicense(String license) {
        if (license != null) {
            return LicenseManagerFactory.getLicenseManager().getLicense(license);
        }
        return null;
    }

    private static CrowdLicense getCrowdLicense(AtlassianLicense atlassianLicense) {
        if (atlassianLicense != null) {
            return (CrowdLicense)atlassianLicense.getProductLicense(Product.CROWD);
        }
        return null;
    }

    public int getCurrentResourceUsageTotal() throws CrowdLicenseManagerException {
        HashSet<GroupTemplate> processedGroups = new HashSet<GroupTemplate>();
        HashSet<Long> processedDirectories = new HashSet<Long>();
        HashSet<LicenseResourceEntity> licenseResourceEntities = new HashSet<LicenseResourceEntity>();
        try {
            List applications = this.applicationManager.findAll();
            for (Application application : applications) {
                for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
                    Long directoryId = directoryMapping.getDirectory().getId();
                    if (directoryMapping.isAllowAllToAuthenticate()) {
                        if (!processedDirectories.contains(directoryId)) {
                            List activeUsers = this.directoryManager.searchUsers(directoryId.longValue(), QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true)).returningAtMost(-1).asNames());
                            licenseResourceEntities.addAll(this.buildResourceEntitiesFromUsernames(directoryId, activeUsers));
                        }
                        processedDirectories.add(directoryId);
                        continue;
                    }
                    for (GroupMapping groupMapping : directoryMapping.getAuthorisedGroups()) {
                        GroupTemplate group = new GroupTemplate(groupMapping.getGroupName(), groupMapping.getDirectory().getId(), GroupType.GROUP);
                        if (processedGroups.contains(group)) continue;
                        List users = this.directoryManager.searchNestedGroupRelationships(directoryMapping.getDirectory().getId().longValue(), QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(group.getName()).returningAtMost(-1));
                        licenseResourceEntities.addAll(this.buildResourceEntitiesFromUsers(directoryId, users));
                        processedGroups.add(group);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CrowdLicenseManagerException("Failed to calculate the current number of active user resources.", (Throwable)e);
        }
        return licenseResourceEntities.size();
    }

    private List<LicenseResourceEntity> buildResourceEntitiesFromUsernames(Long directoryId, List<String> usernames) {
        ArrayList<LicenseResourceEntity> userResourceList = new ArrayList<LicenseResourceEntity>();
        for (String username : usernames) {
            userResourceList.add(new LicenseResourceEntity(directoryId, username));
        }
        return userResourceList;
    }

    private List<LicenseResourceEntity> buildResourceEntitiesFromUsers(Long directoryId, List<User> users) {
        ArrayList<LicenseResourceEntity> userResourceList = new ArrayList<LicenseResourceEntity>();
        for (User user : users) {
            if (!user.isActive()) continue;
            userResourceList.add(new LicenseResourceEntity(directoryId, user.getName()));
        }
        return userResourceList;
    }

    public boolean isResourceTotalOverLimit(float limit, int currentResourceCount) {
        if (this.getLicense().isUnlimitedNumberOfUsers()) {
            return false;
        }
        int userLimit = this.getLicense().getMaximumNumberOfUsers();
        float percentage = (float)currentResourceCount / (float)userLimit * 100.0f;
        log.debug((Object)("Percentage: " + percentage + "%"));
        return percentage >= limit;
    }

    public boolean isBuildWithinMaintenancePeriod(CrowdLicense license) {
        return BuildUtils.getCurrentBuildDate().getTime() < license.getMaintenanceExpiryDate().getTime();
    }

    public boolean isBuildWithinMaintenancePeriod() {
        return this.isBuildWithinMaintenancePeriod(this.getLicense());
    }

    public boolean isBuildWithinMaintenancePeriod(String key) {
        return this.isBuildWithinMaintenancePeriod(CrowdLicenseStore.getCrowdLicense(CrowdLicenseStore.getAtlassianLicense(key)));
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setLicenseStore(CrowdLicenseStore licenseStore) {
        this.licenseStore = licenseStore;
    }
}

