/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor.poller;

import com.atlassian.crowd.integration.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorUnregistrationException;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerBean;

public class DirectoryPollerManagerImpl
implements DirectoryPollerManager {
    public static final String DIRECTORY_POLLER_JOB_GROUP = "DirectoryPoller";
    private static final String POLL_CHANGES_METHOD = "pollChanges";
    private Scheduler scheduler;

    public void addPoller(DirectoryPoller poller) throws DirectoryMonitorRegistrationException {
        try {
            MethodInvokingJobDetailFactoryBean jobDetailFactory = new MethodInvokingJobDetailFactoryBean();
            jobDetailFactory.setName(this.getJobName(poller.getDirectoryID()));
            jobDetailFactory.setGroup(DIRECTORY_POLLER_JOB_GROUP);
            jobDetailFactory.setTargetObject((Object)poller);
            jobDetailFactory.setTargetMethod(POLL_CHANGES_METHOD);
            jobDetailFactory.afterPropertiesSet();
            JobDetail jobDetail = (JobDetail)jobDetailFactory.getObject();
            SimpleTriggerBean trigger = new SimpleTriggerBean();
            trigger.setName(this.getJobName(poller.getDirectoryID()));
            trigger.setGroup(DIRECTORY_POLLER_JOB_GROUP);
            trigger.setJobDetail(jobDetail);
            trigger.setRepeatInterval(poller.getPollingInterval() * 1000L);
            trigger.afterPropertiesSet();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception e) {
            throw new DirectoryMonitorRegistrationException((Throwable)e);
        }
    }

    public boolean hasPoller(long directoryID) {
        boolean registered = false;
        try {
            JobDetail jobDetail = this.scheduler.getJobDetail(this.getJobName(directoryID), DIRECTORY_POLLER_JOB_GROUP);
            if (jobDetail != null) {
                registered = true;
            }
        }
        catch (SchedulerException e) {
            // empty catch block
        }
        return registered;
    }

    public boolean removePoller(long directoryID) throws DirectoryMonitorUnregistrationException {
        try {
            return this.scheduler.deleteJob(this.getJobName(directoryID), DIRECTORY_POLLER_JOB_GROUP);
        }
        catch (SchedulerException e) {
            throw new DirectoryMonitorUnregistrationException((Throwable)e);
        }
    }

    public void removeAllPollers() {
        try {
            String[] directoryIDs;
            for (String directoryID : directoryIDs = this.scheduler.getJobNames(DIRECTORY_POLLER_JOB_GROUP)) {
                try {
                    this.removePoller(Long.parseLong(directoryID));
                }
                catch (DirectoryMonitorUnregistrationException e) {
                    // empty catch block
                }
            }
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    protected String getJobName(long directoryID) {
        return Long.toString(directoryID);
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

