/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.internal;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.PasswordHelper;
import com.atlassian.crowd.integration.directory.AttributeValuesHolder;
import com.atlassian.crowd.integration.directory.BatchingRemoteDirectory;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidMembershipException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.MembershipNotFoundException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import com.atlassian.crowd.integration.model.group.InternalGroup;
import com.atlassian.crowd.integration.model.membership.InternalMembership;
import com.atlassian.crowd.integration.model.user.InternalUser;
import com.atlassian.crowd.integration.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import com.atlassian.crowd.model.directory.DirectoryDAO;
import com.atlassian.crowd.model.group.GroupDAO;
import com.atlassian.crowd.model.membership.MembershipDAO;
import com.atlassian.crowd.model.principal.UserDAO;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalDirectory
implements BatchingRemoteDirectory {
    public static final String DESCRIPTIVE_NAME = "Crowd Internal Directory";
    public static final String ATTRIBUTE_PASSWORD_REGEX = "password_regex";
    public static final String ATTRIBUTE_PASSWORD_MAX_ATTEMPTS = "password_max_attempts";
    public static final String ATTRIBUTE_PASSWORD_HISTORY_COUNT = "password_history_count";
    public static final String ATTRIBUTE_USER_ENCRYPTION_METHOD = "user_encryption_method";
    public static final String ATTRIBUTE_PASSWORD_MAX_CHANGE_TIME = "password_max_change_time";
    private static final int MILLIS_IN_DAY = 86400000;
    protected final Logger logger = Logger.getLogger(this.getClass());
    private long directoryId;
    protected AttributeValuesHolder attributes;
    protected PasswordHelper passwordHelper;
    protected PasswordEncoderFactory passwordEncoderFactory;
    protected DirectoryDAO directoryDAO;
    protected UserDAO userDAO;
    protected GroupDAO groupDAO;
    protected MembershipDAO membershipDAO;
    protected I18nHelper i18nHelper;

    public long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(long id) {
        this.directoryId = id;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = new AttributeValuesHolder(attributes);
    }

    public List<String> getAttributes(String name) {
        return this.attributes.getAttributes(name);
    }

    public String getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    public boolean hasAttribute(String name) {
        return this.attributes.hasAttribute(name);
    }

    public String getDescriptiveName() {
        return DESCRIPTIVE_NAME;
    }

    public User findUserByName(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        return this.userDAO.findByName(this.getDirectoryId(), name);
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        return this.userDAO.findByNameWithAttributes(this.getDirectoryId(), name);
    }

    public User authenticate(String name, PasswordCredential credential) throws ObjectNotFoundException, InactiveAccountException, InvalidAuthenticationException {
        InternalUserWithAttributes user = this.userDAO.findByNameWithAttributes(this.getDirectoryId(), name);
        if (user.isActive()) {
            this.processAuthentication(user, credential);
            return user;
        }
        throw new InactiveAccountException((User)user);
    }

    private void processAuthentication(InternalUserWithAttributes user, PasswordCredential credential) throws InvalidAuthenticationException, ObjectNotFoundException {
        long currentInvalidAttempts = this.processPasswordAttempts(user);
        HashMap<String, List<String>> attributesToUpdate = new HashMap<String, List<String>>();
        try {
            this.authenticate(credential, user.getCredential(), this.getAttribute(ATTRIBUTE_USER_ENCRYPTION_METHOD));
            boolean requiresPasswordChange = this.requiresPasswordChange(user);
            attributesToUpdate.put("requiresPasswordChange", Arrays.asList(Boolean.toString(requiresPasswordChange)));
            attributesToUpdate.put("invalidPasswordAttempts", Arrays.asList(Long.toString(0L)));
            attributesToUpdate.put("lastAuthenticated", Arrays.asList(Long.toString(System.currentTimeMillis())));
            this.userDAO.storeAttributes((User)user, attributesToUpdate);
        }
        catch (InvalidAuthenticationException e) {
            attributesToUpdate.put("invalidPasswordAttempts", Arrays.asList(Long.toString(++currentInvalidAttempts)));
            this.userDAO.storeAttributes((User)user, attributesToUpdate);
            throw e;
        }
    }

    private long processPasswordAttempts(InternalUserWithAttributes user) throws InvalidAuthenticationException, ObjectNotFoundException {
        long currentInvalidAttempts = this.currentPrincipalInvalidPasswordAttempts(user);
        long maxInvalidAttempts = 0L;
        String maxAttemptValue = this.getAttribute(ATTRIBUTE_PASSWORD_MAX_ATTEMPTS);
        if (maxAttemptValue != null && (maxInvalidAttempts = Long.parseLong(maxAttemptValue)) > 0L && currentInvalidAttempts >= maxInvalidAttempts) {
            HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
            attributes.put("requiresPasswordChange", Arrays.asList(Boolean.TRUE.toString()));
            this.userDAO.storeAttributes((User)user, attributes);
            this.logger.info((Object)(user.getName() + ": Maximum allowed invalid password attempts has been reached."));
            throw new InvalidAuthenticationException("Maximum allowed invalid password attempts has been reached");
        }
        return currentInvalidAttempts;
    }

    protected long currentPrincipalInvalidPasswordAttempts(InternalUserWithAttributes user) {
        String attemptsAsString = user.getAttribute("invalidPasswordAttempts");
        long longAttempts = 0L;
        if (attemptsAsString != null) {
            try {
                longAttempts = Long.valueOf(attemptsAsString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return longAttempts;
    }

    protected boolean requiresPasswordChange(InternalUserWithAttributes user) {
        long maxUnchangedDays;
        Boolean requiresPasswordChange = Boolean.valueOf(user.getAttribute("requiresPasswordChange"));
        if (requiresPasswordChange.booleanValue()) {
            return true;
        }
        String maxChangeValue = this.getAttribute(ATTRIBUTE_PASSWORD_MAX_CHANGE_TIME);
        if (maxChangeValue != null && (maxUnchangedDays = Long.parseLong(maxChangeValue)) > 0L) {
            Date lastChanged = null;
            String time = user.getAttribute("passwordLastChanged");
            if (time != null) {
                try {
                    lastChanged = new Date(Long.parseLong(time));
                }
                catch (NumberFormatException e) {
                    lastChanged = new Date();
                }
            } else {
                lastChanged = new Date();
            }
            Date now = new Date();
            long maxUnchangedMilli = maxUnchangedDays * 86400000L;
            if (now.getTime() - lastChanged.getTime() > maxUnchangedMilli) {
                requiresPasswordChange = true;
            }
        }
        return requiresPasswordChange;
    }

    private void authenticate(PasswordCredential providedCredential, PasswordCredential storedCredential, String encoderAlgorithm) throws InvalidAuthenticationException {
        PasswordEncoder encoder = this.passwordEncoderFactory.getInternalEncoder(encoderAlgorithm);
        if (!encoder.isPasswordValid(storedCredential.getCredential(), providedCredential.getCredential(), null)) {
            throw new InvalidAuthenticationException("Failed to authenticate principal, password was invalid");
        }
    }

    public User addUser(UserTemplate user, PasswordCredential credential) throws ObjectNotFoundException, InvalidCredentialException, InvalidUserException {
        InternalUser addedUser;
        this.validateDirectoryForEntity((DirectoryEntity)user);
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        this.validateUsername((User)user, user.getName());
        if (credential != null) {
            this.prepareUserCredentialForAdd(credential, attributes);
        }
        try {
            addedUser = this.userDAO.add((User)user, credential);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
        this.userDAO.storeAttributes((User)addedUser, attributes);
        return addedUser;
    }

    private void validateDirectoryForEntity(DirectoryEntity entity) {
        Validate.notNull((Object)entity, (String)"entity cannot be null");
        Validate.notNull((Object)entity.getDirectoryId(), (String)"directoryId of entity cannot be null");
        Validate.isTrue((boolean)entity.getDirectoryId().equals(this.getDirectoryId()), (String)"directoryId does not match the directoryId of the InternalDirectory");
    }

    private void validateUsername(User user, String username) throws InvalidUserException {
        if (StringUtils.isBlank((String)username)) {
            throw new InvalidUserException(user, "A username must be present");
        }
    }

    private void prepareUserCredentialForAdd(PasswordCredential credential, Map<String, List<String>> attributes) throws InvalidCredentialException {
        this.validateCredential(credential);
        attributes.put("passwordLastChanged", Arrays.asList(Long.toString(System.currentTimeMillis())));
        attributes.put("requiresPasswordChange", Arrays.asList(Boolean.FALSE.toString()));
        this.encryptCredential(credential);
    }

    private void validateCredential(PasswordCredential credential) throws InvalidCredentialException {
        if (credential == null || StringUtils.isBlank((String)credential.getCredential())) {
            throw new InvalidCredentialException(this.i18nHelper.getText("password.change.error.null"));
        }
        String regex = this.getAttribute(ATTRIBUTE_PASSWORD_REGEX);
        if (StringUtils.isNotBlank((String)regex) && !this.passwordHelper.validateRegex(regex, credential)) {
            throw new InvalidCredentialException(this.i18nHelper.getText("password.change.error.complexity"));
        }
    }

    private void encryptCredential(PasswordCredential passwordCredential) {
        if (passwordCredential != null && !passwordCredential.isEncryptedCredential()) {
            String encrypedPassword = this.getEncoder().encodePassword(passwordCredential.getCredential(), null);
            passwordCredential.setCredential(encrypedPassword);
            passwordCredential.setEncryptedCredential(true);
        }
    }

    protected PasswordEncoder getEncoder() {
        String userEncoder = this.getAttribute(ATTRIBUTE_USER_ENCRYPTION_METHOD);
        return this.passwordEncoderFactory.getInternalEncoder(userEncoder);
    }

    public User updateUser(UserTemplate user) throws InvalidUserException, ObjectNotFoundException {
        this.validateDirectoryForEntity((DirectoryEntity)user);
        try {
            return this.userDAO.update((User)user);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
    }

    public void updateUserCredential(String name, PasswordCredential credential) throws ObjectNotFoundException, InvalidCredentialException {
        InternalUser user = this.userDAO.findByName(this.getDirectoryId(), name);
        this.validateCredential(credential);
        this.encryptCredential(credential);
        int historyCount = 0;
        String historyCountString = this.getAttribute(ATTRIBUTE_PASSWORD_HISTORY_COUNT);
        if (NumberUtils.isNumber((String)historyCountString) && (historyCount = Integer.parseInt(historyCountString)) != 0 && !this.passwordHelper.isUniquePassword(credential, user, historyCount)) {
            throw new InvalidCredentialException("Unable to update password since this password matches either the current password or one of the previous " + historyCountString + " passwords");
        }
        try {
            this.userDAO.updateCredential((User)user, credential, historyCount);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidCredentialException((Throwable)e);
        }
        HashMap<String, List<String>> userAttributes = new HashMap<String, List<String>>();
        userAttributes.put("passwordLastChanged", Arrays.asList(Long.toString(new Date().getTime())));
        userAttributes.put("requiresPasswordChange", Arrays.asList(Boolean.FALSE.toString()));
        userAttributes.put("invalidPasswordAttempts", Arrays.asList(Long.toString(0L)));
        this.userDAO.storeAttributes((User)user, userAttributes);
    }

    public User renameUser(String oldName, String newName) throws ObjectNotFoundException, InvalidUserException {
        Validate.notEmpty((String)oldName, (String)"oldName cannot be null or empty");
        Validate.notEmpty((String)newName, (String)"newName cannot be null or empty");
        User user = this.findUserByName(oldName);
        this.validateUsername(user, newName);
        try {
            this.findUserByName(newName);
            throw new InvalidUserException(user, "Cannot rename user as user with new name already exists: " + newName);
        }
        catch (ObjectNotFoundException e) {
            return this.userDAO.rename(user, newName);
        }
    }

    public void storeUserAttributes(String username, Map<String, List<String>> attributes) throws ObjectNotFoundException {
        Validate.notNull(attributes, (String)"attributes cannot be null");
        User user = this.findUserByName(username);
        this.userDAO.storeAttributes(user, attributes);
    }

    public void removeUserAttributes(String username, String attributeName) throws ObjectNotFoundException {
        Validate.notEmpty((String)username, (String)"username cannot be null or empty");
        Validate.notNull((Object)attributeName, (String)"attributeName cannot be null");
        User user = this.findUserByName(username);
        this.userDAO.removeAttribute(user, attributeName);
    }

    public void removeUser(String name) throws ObjectNotFoundException {
        User user = this.findUserByName(name);
        this.userDAO.remove(user);
    }

    public List searchUsers(EntityQuery query) {
        Validate.notNull((Object)query, (String)"query cannot be null");
        return this.userDAO.search(this.getDirectoryId(), query);
    }

    public Group findGroupByName(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        return this.groupDAO.findByName(this.getDirectoryId(), name);
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        return this.groupDAO.findByNameWithAttributes(this.getDirectoryId(), name);
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, ObjectNotFoundException {
        this.validateDirectoryForEntity((DirectoryEntity)group);
        this.validateGroupName((Group)group, group.getName());
        try {
            return this.groupDAO.add((Group)group);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidGroupException((Group)group, e.getMessage(), (Throwable)e);
        }
    }

    private void validateGroupName(Group group, String groupName) throws InvalidGroupException {
        if (StringUtils.isBlank((String)groupName)) {
            throw new InvalidGroupException(group, "A group name must be present");
        }
    }

    public Group updateGroup(GroupTemplate group) throws InvalidGroupException, ObjectNotFoundException {
        this.validateDirectoryForEntity((DirectoryEntity)group);
        try {
            return this.groupDAO.update((Group)group);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidGroupException((Group)group, e.getMessage(), (Throwable)e);
        }
    }

    public Group renameGroup(String oldName, String newName) throws ObjectNotFoundException, InvalidGroupException {
        Validate.notEmpty((String)oldName, (String)"oldName cannot be null or empty");
        Validate.notEmpty((String)newName, (String)"newName cannot be null or empty");
        Group group = this.findGroupByName(oldName);
        this.validateGroupName(group, newName);
        try {
            this.findGroupByName(newName);
            throw new InvalidGroupException(group, "Cannot rename group as group with new name already exists: " + newName);
        }
        catch (ObjectNotFoundException e) {
            return this.groupDAO.rename(group, newName);
        }
    }

    public void storeGroupAttributes(String groupName, Map<String, List<String>> attributes) throws ObjectNotFoundException {
        Validate.notEmpty((String)groupName, (String)"groupName cannot be null or empty");
        Validate.notNull(attributes, (String)"attributes cannot be null");
        Group group = this.findGroupByName(groupName);
        this.groupDAO.storeAttributes(group, attributes);
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws ObjectNotFoundException {
        Validate.notEmpty((String)groupName, (String)"groupName cannot be null or empty");
        Validate.notNull((Object)attributeName, (String)"attributeName cannot be null");
        Group group = this.findGroupByName(groupName);
        this.groupDAO.removeAttribute(group, attributeName);
    }

    public void removeGroup(String name) throws ObjectNotFoundException {
        Group group = this.findGroupByName(name);
        this.groupDAO.remove(group);
    }

    public List searchGroups(EntityQuery query) {
        Validate.notNull((Object)query, (String)"query cannot be null");
        return this.groupDAO.search(this.getDirectoryId(), query);
    }

    public boolean isUserDirectGroupMember(String username, String groupName) {
        Validate.notEmpty((String)username, (String)"username cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName cannot be null or empty");
        return this.membershipDAO.isUserDirectMember(this.getDirectoryId(), username, groupName);
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) {
        Validate.notEmpty((String)childGroup, (String)"childGroup cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup cannot be null or empty");
        return this.membershipDAO.isGroupDirectMember(this.getDirectoryId(), childGroup, parentGroup);
    }

    public void addUserToGroup(String username, String groupName) throws ObjectNotFoundException {
        Validate.notEmpty((String)username, (String)"username cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName cannot be null or empty");
        this.membershipDAO.addUserToGroup(this.getDirectoryId(), username, groupName);
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws ObjectNotFoundException, InvalidMembershipException {
        Validate.notEmpty((String)childGroup, (String)"childGroup cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup cannot be null or empty");
        Group child = this.findGroupByName(childGroup);
        Group parent = this.findGroupByName(parentGroup);
        if (!child.getType().equals((Object)parent.getType())) {
            throw new InvalidMembershipException("Cannot add group of type " + child.getType().name() + " to group of type " + parent.getType().name());
        }
        this.membershipDAO.addGroupToGroup(this.getDirectoryId(), childGroup, parentGroup);
    }

    public void removeUserFromGroup(String username, String groupName) throws ObjectNotFoundException, MembershipNotFoundException {
        Validate.notEmpty((String)username, (String)"username cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName cannot be null or empty");
        this.findUserByName(username);
        this.findGroupByName(groupName);
        if (!this.isUserDirectGroupMember(username, groupName)) {
            throw new MembershipNotFoundException(username, groupName);
        }
        this.membershipDAO.removeUserFromGroup(this.getDirectoryId(), username, groupName);
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws ObjectNotFoundException, InvalidMembershipException, MembershipNotFoundException {
        Validate.notEmpty((String)childGroup, (String)"childGroup cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup cannot be null or empty");
        Group child = this.findGroupByName(childGroup);
        Group parent = this.findGroupByName(parentGroup);
        if (!this.isGroupDirectGroupMember(childGroup, parentGroup)) {
            throw new MembershipNotFoundException(childGroup, parentGroup);
        }
        if (!child.getType().equals((Object)parent.getType())) {
            throw new InvalidMembershipException("Cannot remove group of type " + child.getType().name() + " from group of type " + parent.getType().name());
        }
        this.membershipDAO.removeGroupFromGroup(this.getDirectoryId(), childGroup, parentGroup);
    }

    public List searchGroupRelationships(MembershipQuery query) {
        Validate.notNull((Object)query, (String)"query cannot be null");
        return this.membershipDAO.search(this.getDirectoryId(), query);
    }

    public Collection<User> addAllUsers(Set<UserTemplateWithCredentialAndAttributes> users) throws ObjectNotFoundException {
        Validate.notNull(users, (String)"users cannot be null");
        HashSet<UserTemplateWithCredentialAndAttributes> preparedUsers = new HashSet<UserTemplateWithCredentialAndAttributes>();
        ArrayList<User> failedUsers = new ArrayList<User>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                this.validateDirectoryForEntity((DirectoryEntity)user);
                this.validateUsername((User)user, user.getName());
                this.prepareUserCredentialForAdd(user.getCredential(), user.getAttributes());
                preparedUsers.add(user);
            }
            catch (InvalidUserException e) {
                failedUsers.add((User)user);
                this.logger.error((Object)("Cannot add invalid user " + user.getName()), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                if (user == null) {
                    throw new IllegalArgumentException("Cannot add null user. " + e);
                }
                failedUsers.add((User)user);
                this.logger.error((Object)("Cannot add invalid user " + user.getName()), (Throwable)e);
            }
            catch (InvalidCredentialException e) {
                failedUsers.add((User)user);
                this.logger.error((Object)("Cannot add user with invalid password " + user.getName()), (Throwable)e);
            }
        }
        BatchResult result = this.userDAO.addAll(this.getDirectoryId(), preparedUsers);
        failedUsers.addAll(result.getFailedEntities());
        return failedUsers;
    }

    public Collection<Group> addAllGroups(Set<GroupTemplate> groups) throws ObjectNotFoundException {
        Validate.notNull(groups, (String)"groups cannot be null");
        HashSet<GroupTemplate> preparedGroups = new HashSet<GroupTemplate>();
        ArrayList<Group> failedGroups = new ArrayList<Group>();
        for (GroupTemplate group : groups) {
            try {
                this.validateDirectoryForEntity((DirectoryEntity)group);
                this.validateGroupName((Group)group, group.getName());
                preparedGroups.add(group);
            }
            catch (InvalidGroupException e) {
                failedGroups.add((Group)group);
                this.logger.error((Object)("Cannot add invalid group " + group.getName()), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                if (group == null) {
                    throw new IllegalArgumentException("Cannot add null group. " + e);
                }
                failedGroups.add((Group)group);
                this.logger.error((Object)("Cannot add invalid group " + group.getName()), (Throwable)e);
            }
        }
        BatchResult result = this.groupDAO.addAll(this.getDirectoryId(), preparedGroups);
        failedGroups.addAll(result.getFailedEntities());
        return failedGroups;
    }

    public Collection<String> addAllUsersToGroup(Set<String> userNames, String groupName) throws ObjectNotFoundException {
        Validate.notNull(userNames, (String)"userNames cannot be null");
        Validate.notEmpty((String)groupName, (String)"groupName cannot be null or empty");
        InternalGroup group = this.groupDAO.findByName(this.getDirectoryId(), groupName);
        ArrayList<String> failedUsers = new ArrayList<String>();
        HashSet<InternalMembership> memberships = new HashSet<InternalMembership>(userNames.size());
        Collection users = this.userDAO.findByNames(this.getDirectoryId(), userNames);
        for (InternalUser user : users) {
            memberships.add(new InternalMembership(group, user));
        }
        BatchResult result = this.membershipDAO.addAll(memberships);
        for (InternalMembership membership : result.getFailedEntities()) {
            failedUsers.add(membership.getChildName());
        }
        if (userNames.size() != users.size()) {
            HashSet<String> existingUserNames = new HashSet<String>(users.size());
            for (InternalUser user : users) {
                existingUserNames.add(user.getName());
            }
            HashSet<String> notAddedUsers = new HashSet<String>(userNames);
            notAddedUsers.removeAll(existingUserNames);
            failedUsers.addAll(notAddedUsers);
        }
        return failedUsers;
    }

    public Collection<User> findUsersByNames(Collection<String> names) {
        Validate.notNull(names);
        return new ArrayList<User>(this.userDAO.findByNames(this.getDirectoryId(), names));
    }

    public Collection<Group> findGroupsByNames(Collection<String> names) {
        Validate.notNull(names);
        return new ArrayList<Group>(this.groupDAO.findByNames(this.getDirectoryId(), names));
    }

    public void testConnection() throws DirectoryAccessException {
    }

    public boolean supportsNestedGroups() {
        return this.attributes.getAttributeAsBoolean("useNestedGroups", false);
    }

    public void setPasswordHelper(PasswordHelper passwordHelper) {
        this.passwordHelper = passwordHelper;
    }

    public void setPasswordEncoderFactory(PasswordEncoderFactory passwordEncoderFactory) {
        this.passwordEncoderFactory = passwordEncoderFactory;
    }

    public void setDirectoryDAO(DirectoryDAO directoryDAO) {
        this.directoryDAO = directoryDAO;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setGroupDAO(GroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setMembershipDAO(MembershipDAO membershipDAO) {
        this.membershipDAO = membershipDAO;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }
}

