/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper;

import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.entity.LDAPUserAttributesMapper;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.integration.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.util.connector.DNStandardiser;
import java.util.List;
import javax.naming.directory.Attributes;
import org.apache.log4j.Logger;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DistinguishedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserContextMapper
implements ContextMapper {
    private final Logger logger = Logger.getLogger(this.getClass());
    protected final long directoryId;
    protected final LDAPPropertiesMapper ldapPropertiesMapper;
    protected final List<AttributeMapper> customAttributeMappers;

    public UserContextMapper(long directoryId, LDAPPropertiesMapper ldapPropertiesMapper, List<AttributeMapper> customAttributeMappers) {
        this.directoryId = directoryId;
        this.ldapPropertiesMapper = ldapPropertiesMapper;
        this.customAttributeMappers = customAttributeMappers;
    }

    public Object mapFromContext(Object ctx) throws NamingException {
        DirContextAdapter context = (DirContextAdapter)ctx;
        Attributes attributes = context.getAttributes();
        LDAPUserAttributesMapper mapper = this.getAttributesMapper();
        UserTemplateWithAttributes userTemplate = mapper.mapUserFromAttributes(attributes);
        for (AttributeMapper attributeMapper : this.customAttributeMappers) {
            try {
                userTemplate.setAttribute(attributeMapper.getKey(), attributeMapper.getValues(context));
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed to map attribute <" + attributeMapper.getKey() + "> from context with DN <" + context.getDn().toString() + ">"));
            }
        }
        String dn = DNStandardiser.standardise((DistinguishedName)context.getDn(), !this.ldapPropertiesMapper.isRelaxedDnStandardisation());
        LDAPUserWithAttributes user = new LDAPUserWithAttributes(dn, userTemplate);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created user <" + user + "> from DN <" + context.getDn() + ">"));
        }
        return user;
    }

    protected LDAPUserAttributesMapper getAttributesMapper() {
        return new LDAPUserAttributesMapper(this.directoryId, this.ldapPropertiesMapper);
    }
}

