/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.directory.AttributeValuesHolder;
import com.atlassian.crowd.integration.directory.connector.LDAPDirectory;
import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapper;
import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapperImpl;
import com.atlassian.crowd.integration.directory.connector.mapper.GroupContextMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.UserContextMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.entity.LDAPGroupAttributesMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.entity.LDAPUserAttributesMapper;
import com.atlassian.crowd.integration.directory.connector.name.Converter;
import com.atlassian.crowd.integration.directory.connector.name.Encoder;
import com.atlassian.crowd.integration.directory.connector.name.GenericConverter;
import com.atlassian.crowd.integration.directory.connector.name.GenericEncoder;
import com.atlassian.crowd.integration.directory.connector.name.SearchDN;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.LDAPDirectoryEntity;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.ReturnType;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.ldap.LDAPQuery;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.search.ldap.NullResultException;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.connector.DNStandardiser;
import com.atlassian.crowd.util.search.SearchResultsUtil;
import com.atlassian.event.EventManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.control.PagedResultsRequestControl;
import org.springframework.ldap.core.CollectingNameClassPairCallbackHandler;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextMapperCallbackHandler;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.support.AggregateDirContextProcessor;
import org.springframework.ldap.core.support.LdapContextSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpringLDAPConnector
implements LDAPDirectory,
ApplicationContextAware {
    public static final int DEFAULT_PAGE_SIZE = 999;
    protected final Logger logger = Logger.getLogger(this.getClass());
    private long directoryId;
    protected AttributeValuesHolder attributes;
    protected LdapTemplate ldapTemplate;
    protected LDAPPropertiesMapper ldapPropertiesMapper;
    protected LdapContextSource contextSource;
    protected Converter nameConverter;
    protected SearchDN searchDN;
    protected ApplicationContext applicationContext;
    protected LDAPQueryTranslater ldapQueryTranslater;
    protected EventManager eventManager;

    public long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(long id) {
        this.directoryId = id;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = new AttributeValuesHolder(attributes);
        Object object = this.applicationContext.getAutowireCapableBeanFactory().createBean(LDAPPropertiesMapperImpl.class, 1, false);
        this.ldapPropertiesMapper = (LDAPPropertiesMapper)object;
        this.ldapPropertiesMapper.setAttributes(attributes);
        this.contextSource = new LdapContextSource();
        this.contextSource.setUrl(this.ldapPropertiesMapper.getConnectionURL());
        this.contextSource.setUserDn(this.ldapPropertiesMapper.getUsername());
        this.contextSource.setPassword(this.ldapPropertiesMapper.getPassword());
        this.contextSource.setBaseEnvironmentProperties(this.getBaseEnvironmentProperties());
        this.contextSource.setPooled(true);
        try {
            this.contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            this.logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        this.ldapTemplate = new LdapTemplate((ContextSource)this.contextSource);
        this.nameConverter = new GenericConverter(this.getEncoder());
        this.searchDN = new SearchDN(this.ldapPropertiesMapper, this.nameConverter);
    }

    public LdapContextSource getContextSource() {
        return this.contextSource;
    }

    public LDAPPropertiesMapper getLdapPropertiesMapper() {
        return this.ldapPropertiesMapper;
    }

    public List<String> getAttributes(String name) {
        return this.attributes.getAttributes(name);
    }

    public String getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    public long getAttributeAsLong(String name, long defaultValue) {
        return this.attributes.getAttributeAsLong(name, defaultValue);
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        return this.attributes.getAttributeAsBoolean(name, defaultValue);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    public boolean hasAttribute(String name) {
        return this.attributes.hasAttribute(name);
    }

    public SearchDN getSearchDN() {
        return this.searchDN;
    }

    protected SearchControls getSubTreeSearchControl() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningObjFlag(true);
        return searchControls;
    }

    protected Encoder getEncoder() {
        return new GenericEncoder();
    }

    protected Hashtable<String, String> getBaseEnvironmentProperties() {
        return this.ldapPropertiesMapper.getEnvironment();
    }

    protected CollectingNameClassPairCallbackHandler pageSearchResults(Name baseDN, String filter, ContextMapper contextMapper, SearchControls searchControls, DirContextProcessor ldapRequestControls, int maxResults) {
        int pagingSize = this.ldapPropertiesMapper.getPagedResultsSize();
        PagedResultsRequestControl pagedResultsControl = new PagedResultsRequestControl(pagingSize);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Paged results are enabled with a paging size of: " + pagingSize));
        }
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(contextMapper);
        byte[] cookie = null;
        do {
            AggregateDirContextProcessor aggregateDirContextProcessor = new AggregateDirContextProcessor();
            aggregateDirContextProcessor.addDirContextProcessor((DirContextProcessor)pagedResultsControl);
            if (ldapRequestControls != null) {
                aggregateDirContextProcessor.addDirContextProcessor(ldapRequestControls);
            }
            this.ldapTemplate.search(baseDN, filter, searchControls, (NameClassPairCallbackHandler)handler, (DirContextProcessor)aggregateDirContextProcessor);
            if (this.logger.isDebugEnabled()) {
                int resultSize = pagedResultsControl.getPageSize();
                this.logger.debug((Object)("Iterating a search result size of: " + resultSize));
            }
            if ((pagedResultsControl = new PagedResultsRequestControl(pagingSize, pagedResultsControl.getCookie())).getCookie() == null) continue;
            cookie = pagedResultsControl.getCookie().getCookie();
        } while (cookie != null && cookie.length != 0 && (handler.getList().size() < maxResults || maxResults == -1));
        return handler;
    }

    protected List searchEntities(Name baseDN, String filter, ContextMapper contextMapper, int startIndex, int maxResults) {
        return this.searchEntitiesWithRequestControls(baseDN, filter, contextMapper, this.getSubTreeSearchControl(), null, startIndex, maxResults);
    }

    protected List searchEntitiesWithRequestControls(Name baseDN, String filter, ContextMapper contextMapper, SearchControls searchControls, DirContextProcessor ldapRequestControls, int startIndex, int maxResults) {
        List results = Collections.emptyList();
        if (this.ldapPropertiesMapper.isPagedResultsControl()) {
            CollectingNameClassPairCallbackHandler handler = this.pageSearchResults(baseDN, filter, contextMapper, searchControls, ldapRequestControls, maxResults);
            results = handler.getList();
        } else {
            results = ldapRequestControls != null ? this.ldapTemplate.search(baseDN, filter, searchControls, contextMapper, ldapRequestControls) : this.ldapTemplate.search(baseDN, filter, searchControls, contextMapper);
        }
        return SearchResultsUtil.constrainResults(results, startIndex, maxResults);
    }

    private String spaceIfBlank(String value) {
        if (StringUtils.isBlank((String)value)) {
            return " ";
        }
        return value;
    }

    private ModificationItem createModificationItem(String directoryAttributeName, String oldValue, String newValue) {
        ModificationItem modificationItem = oldValue == null && newValue == null ? null : (oldValue == null ? new ModificationItem(1, new BasicAttribute(directoryAttributeName, this.spaceIfBlank(newValue))) : (!oldValue.equals(newValue) ? new ModificationItem(2, new BasicAttribute(directoryAttributeName, this.spaceIfBlank(newValue))) : null));
        return modificationItem;
    }

    public ContextMapper getUserContextMapper() {
        return new UserContextMapper(this.getDirectoryId(), this.ldapPropertiesMapper, this.getCustomUserAttributeMappers());
    }

    protected List<AttributeMapper> getCustomUserAttributeMappers() {
        return new ArrayList<AttributeMapper>();
    }

    public ContextMapper getGroupContextMapper(GroupType groupType) {
        return new GroupContextMapper(this.getDirectoryId(), groupType, this.ldapPropertiesMapper, this.getCustomGroupAttributeMappers());
    }

    protected List<AttributeMapper> getCustomGroupAttributeMappers() {
        return new ArrayList<AttributeMapper>();
    }

    public LDAPUserWithAttributes findUserByName(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        return this.findUserWithAttributesByName(name);
    }

    public LDAPUserWithAttributes findUserWithAttributesByName(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        EntityQuery query = QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)name)).returningAtMost(1);
        List<LDAPUserWithAttributes> users = this.searchUserObjects(query);
        if (users.isEmpty()) {
            throw new ObjectNotFoundException(User.class, (Object)name);
        }
        return users.get(0);
    }

    protected List<LDAPUserWithAttributes> searchUserObjects(EntityQuery query) {
        List results;
        if (query == null) {
            throw new IllegalArgumentException("user search can only evaluate non-null EntityQueries for Entity.USER");
        }
        if (query.getEntityDescriptor().getEntityType() != Entity.USER) {
            throw new IllegalArgumentException("user search can only evaluate EntityQueries for Entity.USER");
        }
        Name baseDN = this.searchDN.getUser();
        try {
            LDAPQuery ldapQuery = this.ldapQueryTranslater.asLDAPFilter(query, this.ldapPropertiesMapper);
            String filter = ldapQuery.encode();
            this.logger.info((Object)("Performing user search: baseDN = " + baseDN + " - filter = " + filter));
            results = this.searchEntities(baseDN, filter, this.getUserContextMapper(), query.getStartIndex(), query.getMaxResults());
        }
        catch (NullResultException e) {
            results = Collections.emptyList();
        }
        return results;
    }

    public void removeUser(String name) throws ObjectNotFoundException {
        Validate.notEmpty((String)name, (String)"name argument cannot be null or empty");
        LDAPUserWithAttributes user = this.findUserByName(name);
        this.ldapTemplate.unbind((Name)this.asLdapName(user.getDn(), LDAPUserWithAttributes.class));
    }

    public void updateUserCredential(String name, PasswordCredential credential) throws ObjectNotFoundException, InvalidCredentialException {
        Validate.notEmpty((String)name, (String)"name argument cannot be null or empty");
        Validate.notNull((Object)credential, (String)"credential argument cannot be null");
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.ldapPropertiesMapper.getUserPasswordAttribute(), this.encodePassword(credential.getCredential())))};
        LdapName userDn = this.asLdapName(this.findUserByName(name).getDn(), LDAPUserWithAttributes.class);
        this.ldapTemplate.modifyAttributes((Name)userDn, mods);
    }

    public User renameUser(String oldName, String newName) throws ObjectNotFoundException, InvalidUserException {
        throw new UnsupportedOperationException("User renaming is not yet supported for LDAP directories");
    }

    public void storeUserAttributes(String username, Map<String, List<String>> attributes) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("Custom user attributes are not yet supported for LDAP directories");
    }

    public void removeUserAttributes(String username, String attributeName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("Custom user attributes are not yet supported for LDAP directories");
    }

    protected Attributes getNewUserAttributes(User user, PasswordCredential credential) throws InvalidCredentialException, NamingException {
        LDAPUserAttributesMapper mapper = new LDAPUserAttributesMapper(this.getDirectoryId(), this.ldapPropertiesMapper);
        Attributes attributes = mapper.mapAttributesFromUser(user);
        if (credential != null && credential.getCredential() != null) {
            String unencodedPassword = credential.getCredential();
            attributes.put(this.ldapPropertiesMapper.getUserPasswordAttribute(), this.encodePassword(unencodedPassword));
        }
        this.getNewUserDirectorySpecificAttributes(user, attributes);
        return attributes;
    }

    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
    }

    public LDAPUserWithAttributes addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, ObjectNotFoundException {
        Validate.notNull((Object)user, (String)"user cannot be null");
        Validate.notNull((Object)user.getName(), (String)"user.name cannot be null");
        try {
            Name dn = this.nameConverter.getName(this.ldapPropertiesMapper.getUserNameRdnAttribute(), user.getName(), this.searchDN.getUser());
            Attributes attrs = this.getNewUserAttributes((User)user, credential);
            this.ldapTemplate.bind(dn, null, attrs);
            return this.findEntityByDN(this.getStandardisedDN(dn), LDAPUserWithAttributes.class);
        }
        catch (NamingException e) {
            throw new InvalidUserException((DirectoryEntity)user, (Throwable)e);
        }
    }

    protected void addDefaultSnToUserAttributes(Attributes attrs, String defaultSnValue) {
        this.addDefaultValueToUserAttributesForAttribute(this.ldapPropertiesMapper.getUserLastNameAttribute(), attrs, defaultSnValue);
    }

    protected void addDefaultValueToUserAttributesForAttribute(String attributeName, Attributes attrs, String defaultValue) {
        if (attrs == null) {
            return;
        }
        Attribute userAttribute = attrs.get(attributeName);
        if (userAttribute == null) {
            attrs.put(new BasicAttribute(attributeName, defaultValue));
        }
    }

    @Override
    public <T extends LDAPDirectoryEntity> T findEntityByDN(String dn, Class<T> entityClass) throws ObjectNotFoundException {
        try {
            if (User.class.isAssignableFrom(entityClass)) {
                return this.findEntityByDN(dn, this.getStandardisedDN(this.searchDN.getUser()), this.ldapPropertiesMapper.getUserFilter(), this.getUserContextMapper(), entityClass);
            }
            if (Group.class.isAssignableFrom(entityClass)) {
                String groupBaseDN = this.getStandardisedDN(this.searchDN.getGroup());
                String roleBaseDN = this.getStandardisedDN(this.searchDN.getRole());
                if (dn.endsWith(groupBaseDN)) {
                    return this.findEntityByDN(dn, groupBaseDN, this.ldapPropertiesMapper.getGroupFilter(), this.getGroupContextMapper(GroupType.GROUP), entityClass);
                }
                if (dn.endsWith(roleBaseDN)) {
                    return this.findEntityByDN(dn, roleBaseDN, this.ldapPropertiesMapper.getRoleFilter(), this.getGroupContextMapper(GroupType.LEGACY_ROLE), entityClass);
                }
                return this.findEntityByDN(dn, groupBaseDN, this.ldapPropertiesMapper.getGroupFilter(), this.getGroupContextMapper(GroupType.GROUP), entityClass);
            }
            throw new ObjectNotFoundException(entityClass, (Object)dn);
        }
        catch (InvalidNameException e) {
            throw new ObjectNotFoundException(entityClass, (Object)dn);
        }
    }

    protected <T extends LDAPDirectoryEntity> T findEntityByDN(String dn, String baseDN, String filter, ContextMapper contextMapper, Class<T> entityClass) throws ObjectNotFoundException, InvalidNameException {
        if (StringUtils.isBlank((String)dn)) {
            throw new ObjectNotFoundException(entityClass, (Object)"Blank DN");
        }
        if (dn.endsWith(baseDN)) {
            List entities;
            block8: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Executing search at DN: <" + dn + "> with filter: <" + filter + ">"));
                }
                entities = null;
                try {
                    entities = this.ldapTemplate.search((Name)new LdapName(dn), filter, 0, contextMapper);
                }
                catch (NameNotFoundException e) {
                    if (!this.logger.isDebugEnabled()) break block8;
                    this.logger.debug((Object)e);
                }
            }
            if (entities != null && !entities.isEmpty()) {
                return (T)((LDAPDirectoryEntity)entities.get(0));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Entity DN <" + dn + "> does not exist or does not match filter <" + filter + ">"));
            }
            throw new ObjectNotFoundException(entityClass, (Object)dn);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entity DN <" + dn + "> is outside the entity base DN subtree scope <" + baseDN + ">"));
        }
        throw new ObjectNotFoundException(entityClass, (Object)dn);
    }

    public User updateUser(UserTemplate user) throws ObjectNotFoundException {
        Validate.notNull((Object)user, (String)"user cannot be null");
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)user.getName()), (String)"user cannot have blank user name");
        LDAPUserWithAttributes currentUser = this.findUserByName(user.getName());
        String ldapUserObjectType = this.ldapPropertiesMapper.getUserObjectClass();
        ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
        if ("inetOrgPerson".equalsIgnoreCase(ldapUserObjectType) || "user".equalsIgnoreCase(ldapUserObjectType)) {
            ModificationItem displayNameMod;
            ModificationItem givenNameMod;
            ModificationItem mailMod;
            ModificationItem snMod = this.createModificationItem(this.ldapPropertiesMapper.getUserLastNameAttribute(), currentUser.getLastName(), user.getLastName());
            if (snMod != null) {
                modificationItems.add(snMod);
            }
            if ((mailMod = this.createModificationItem(this.ldapPropertiesMapper.getUserEmailAttribute(), currentUser.getEmailAddress(), user.getEmailAddress())) != null) {
                modificationItems.add(mailMod);
            }
            if ((givenNameMod = this.createModificationItem(this.ldapPropertiesMapper.getUserFirstNameAttribute(), currentUser.getFirstName(), user.getFirstName())) != null) {
                modificationItems.add(givenNameMod);
            }
            if ((displayNameMod = this.createModificationItem(this.ldapPropertiesMapper.getUserDisplayNameAttribute(), currentUser.getDisplayName(), user.getDisplayName())) != null) {
                modificationItems.add(displayNameMod);
            }
        }
        if (!modificationItems.isEmpty()) {
            this.ldapTemplate.modifyAttributes((Name)this.asLdapName(currentUser.getDn(), LDAPUserWithAttributes.class), modificationItems.toArray(new ModificationItem[modificationItems.size()]));
        }
        return (User)this.findEntityByDN(currentUser.getDn(), LDAPUserWithAttributes.class);
    }

    public List searchUsers(EntityQuery query) {
        List<LDAPUserWithAttributes> users = this.searchUserObjects(query);
        if (query.getReturnType() == ReturnType.NAME) {
            return SearchResultsUtil.convertEntitiesToNames(users);
        }
        return users;
    }

    public User authenticate(String name, PasswordCredential credential) throws InvalidAuthenticationException, ObjectNotFoundException {
        LdapContextSource ctxSource = new LdapContextSource();
        ctxSource.setUrl(this.ldapPropertiesMapper.getConnectionURL());
        LDAPUserWithAttributes user = this.findUserByName(name);
        ctxSource.setUserDn(user.getDn());
        if (credential == null || StringUtils.isBlank((String)credential.getCredential())) {
            throw new InvalidAuthenticationException("You cannot authenticate with a blank password");
        }
        ctxSource.setPassword(credential.getCredential());
        ctxSource.setBaseEnvironmentProperties(this.getBaseEnvironmentProperties());
        ctxSource.setPooled(false);
        try {
            ctxSource.afterPropertiesSet();
            ctxSource.getReadWriteContext();
        }
        catch (Exception e) {
            throw new InvalidAuthenticationException(StringEscapeUtils.escapeJava((String)e.getMessage()), (Throwable)e);
        }
        return user;
    }

    public LDAPGroupWithAttributes findGroupByName(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        return this.findGroupWithAttributesByName(name);
    }

    public LDAPGroupWithAttributes findGroupWithAttributesByName(String name) throws ObjectNotFoundException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        EntityQuery query = QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)name)).returningAtMost(1);
        List<LDAPGroupWithAttributes> groups = this.searchGroupObjects(query);
        if (groups.isEmpty()) {
            throw new ObjectNotFoundException(Group.class, (Object)name);
        }
        return groups.get(0);
    }

    protected LDAPGroupWithAttributes findGroupByNameAndType(String name, GroupType groupType) throws ObjectNotFoundException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        EntityQuery query = QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)name)).returningAtMost(1);
        List<LDAPGroupWithAttributes> groups = this.searchGroupObjects(query);
        if (groups.isEmpty()) {
            throw new ObjectNotFoundException(Group.class, (Object)name);
        }
        return groups.get(0);
    }

    protected List<LDAPGroupWithAttributes> searchGroupObjectsOfSpecifiedGroupType(EntityQuery query) {
        Name baseDN;
        GroupType groupType = query.getEntityDescriptor().getGroupType();
        if (GroupType.GROUP.equals((Object)groupType)) {
            baseDN = this.searchDN.getGroup();
        } else if (GroupType.LEGACY_ROLE.equals((Object)groupType)) {
            baseDN = this.searchDN.getRole();
        } else {
            throw new IllegalArgumentException("Cannot search for groups of type: " + groupType);
        }
        List results = null;
        try {
            LDAPQuery ldapQuery = this.ldapQueryTranslater.asLDAPFilter(query, this.ldapPropertiesMapper);
            String filter = ldapQuery.encode();
            this.logger.info((Object)("Performing group search: baseDN = " + baseDN + " - filter = " + filter));
            results = this.searchEntities(baseDN, filter, this.getGroupContextMapper(groupType), query.getStartIndex(), query.getMaxResults());
        }
        catch (NullResultException e) {
            results = Collections.emptyList();
        }
        return results;
    }

    protected List<LDAPGroupWithAttributes> searchGroupObjects(EntityQuery query) {
        Validate.notNull((Object)query, (String)"query argument cannot be null");
        if (query.getEntityDescriptor().getEntityType() != Entity.GROUP) {
            throw new IllegalArgumentException("group search can only evaluate EntityQueries for Entity.GROUP");
        }
        GroupType groupType = query.getEntityDescriptor().getGroupType();
        if (groupType == null) {
            ArrayList<LDAPGroupWithAttributes> results = new ArrayList<LDAPGroupWithAttributes>();
            int groupStartIndex = query.getStartIndex();
            int groupMaxResults = query.getMaxResults();
            if (!this.ldapPropertiesMapper.isRolesDisabled()) {
                groupStartIndex = 0;
                groupMaxResults = -1;
            }
            EntityQuery groupQuery = new EntityQuery(EntityDescriptor.group((GroupType)GroupType.GROUP), query.getSearchRestriction(), groupStartIndex, groupMaxResults, query.getReturnType());
            results.addAll(this.searchGroupObjectsOfSpecifiedGroupType(groupQuery));
            if (!this.ldapPropertiesMapper.isRolesDisabled()) {
                EntityQuery roleQuery = new EntityQuery(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE), query.getSearchRestriction(), groupStartIndex, groupMaxResults, query.getReturnType());
                results.addAll(this.searchGroupObjectsOfSpecifiedGroupType(roleQuery));
            }
            return SearchResultsUtil.constrainResults(results, query.getStartIndex(), query.getMaxResults());
        }
        return this.searchGroupObjectsOfSpecifiedGroupType(query);
    }

    public List searchGroups(EntityQuery query) {
        Validate.notNull((Object)query, (String)"query argument cannot be null");
        List<LDAPGroupWithAttributes> groups = this.searchGroupObjects(query);
        if (query.getReturnType() == ReturnType.NAME) {
            return SearchResultsUtil.convertEntitiesToNames(groups);
        }
        return groups;
    }

    protected Attributes getNewGroupAttributes(Group group) throws NamingException {
        LDAPGroupAttributesMapper mapper = new LDAPGroupAttributesMapper(this.getDirectoryId(), group.getType(), this.ldapPropertiesMapper);
        Attributes attributes = mapper.mapAttributesFromGroup(group);
        this.getNewGroupDirectorySpecificAttributes(group, attributes);
        String defaultContainerMemberDN = this.getInitialGroupMemberDN();
        if (defaultContainerMemberDN != null) {
            attributes.put(new BasicAttribute(this.ldapPropertiesMapper.getGroupMemberAttribute(), defaultContainerMemberDN));
        }
        return attributes;
    }

    protected void getNewGroupDirectorySpecificAttributes(Group group, Attributes attributes) {
    }

    protected String getInitialGroupMemberDN() {
        return "";
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, ObjectNotFoundException {
        Validate.notNull((Object)group, (String)"group cannot be null");
        Validate.notNull((Object)group.getName(), (String)"group.name cannot be null");
        try {
            this.findGroupByName(group.getName());
            throw new InvalidGroupException((Group)group, "Group already exists");
        }
        catch (ObjectNotFoundException e) {
            String nameAttribute;
            Name baseDN;
            if (group.getType() == GroupType.GROUP) {
                baseDN = this.searchDN.getGroup();
                nameAttribute = this.ldapPropertiesMapper.getGroupNameAttribute();
            } else if (group.getType() == GroupType.LEGACY_ROLE) {
                baseDN = this.searchDN.getRole();
                nameAttribute = this.ldapPropertiesMapper.getRoleNameAttribute();
            } else {
                throw new InvalidGroupException((Group)group, "group.type must be GroupType.GROUP or GroupType.LEGACY_ROLE");
            }
            try {
                Name dn = this.nameConverter.getName(nameAttribute, group.getName(), baseDN);
                Attributes groupAttributes = this.getNewGroupAttributes((Group)group);
                this.ldapTemplate.bind(dn, null, groupAttributes);
                return (Group)this.findEntityByDN(this.getStandardisedDN(dn), LDAPGroupWithAttributes.class);
            }
            catch (NamingException e1) {
                throw new InvalidGroupException((DirectoryEntity)group, (Throwable)e1);
            }
        }
    }

    public Group updateGroup(GroupTemplate group) throws ObjectNotFoundException {
        Validate.notNull((Object)group, (String)"group cannot be null");
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)group.getName()), (String)"group cannot have blank group name");
        LDAPGroupWithAttributes currentGroup = this.findGroupByName(group.getName());
        if (currentGroup.getType() != group.getType()) {
            throw new UnsupportedOperationException("Cannot modify the GroupType for an LDAP group");
        }
        ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
        String descriptionAttribute = group.getType() == GroupType.GROUP ? this.ldapPropertiesMapper.getGroupDescriptionAttribute() : this.ldapPropertiesMapper.getRoleDescriptionAttribute();
        ModificationItem descriptionMod = this.createModificationItem(descriptionAttribute, currentGroup.getDescription(), group.getDescription());
        if (descriptionMod != null) {
            modificationItems.add(descriptionMod);
        }
        if (!modificationItems.isEmpty()) {
            this.ldapTemplate.modifyAttributes((Name)this.asLdapName(currentGroup.getDn(), LDAPGroupWithAttributes.class), modificationItems.toArray(new ModificationItem[modificationItems.size()]));
        }
        return (Group)this.findEntityByDN(currentGroup.getDn(), LDAPGroupWithAttributes.class);
    }

    public void removeGroup(String name) throws ObjectNotFoundException {
        Validate.notEmpty((String)name, (String)"name argument cannot be null or empty");
        LDAPGroupWithAttributes group = this.findGroupByName(name);
        this.ldapTemplate.unbind((Name)this.asLdapName(group.getDn(), LDAPGroupWithAttributes.class));
    }

    public Group renameGroup(String oldName, String newName) throws ObjectNotFoundException, InvalidGroupException {
        throw new UnsupportedOperationException("Group renaming is not yet supported for LDAP directories");
    }

    public void storeGroupAttributes(String groupName, Map<String, List<String>> attributes) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("Custom group attributes are not yet supported for LDAP directories");
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("Custom group attributes are not yet supported for LDAP directories");
    }

    public List searchGroupRelationships(MembershipQuery query) {
        List results;
        Validate.notNull((Object)query, (String)"query argument cannot be null");
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP && query.getEntityToMatch().getEntityType() != query.getEntityToReturn().getEntityType()) {
            throw new IllegalArgumentException("Cannot search for group relationships of mismatching GroupTypes: attempted to match <" + query.getEntityToMatch().getEntityType() + "> and return <" + query.getEntityToReturn().getEntityType() + ">");
        }
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.USER) {
            GroupType groupType = query.getEntityToMatch().getGroupType();
            if (groupType == null) {
                MembershipQuery groupQuery = new MembershipQuery(query.isFindMembers(), EntityDescriptor.group((GroupType)GroupType.GROUP), query.getEntityNameToMatch(), query.getEntityToReturn(), query.getStartIndex(), query.getMaxResults(), query.getReturnType());
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(groupQuery);
                if (!this.ldapPropertiesMapper.isRolesDisabled() && results.isEmpty()) {
                    MembershipQuery roleQuery = new MembershipQuery(query.isFindMembers(), EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE), query.getEntityNameToMatch(), query.getEntityToReturn(), query.getStartIndex(), query.getMaxResults(), query.getReturnType());
                    results = this.searchGroupRelationshipsWithGroupTypeSpecified(roleQuery);
                }
            } else {
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(query);
            }
        } else if (query.getEntityToMatch().getEntityType() == Entity.USER && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            GroupType groupType = query.getEntityToReturn().getGroupType();
            if (groupType == null) {
                MembershipQuery groupQuery = new MembershipQuery(query.isFindMembers(), query.getEntityToMatch(), query.getEntityNameToMatch(), EntityDescriptor.group((GroupType)GroupType.GROUP), query.getStartIndex(), query.getMaxResults(), query.getReturnType());
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(groupQuery);
                if (!this.ldapPropertiesMapper.isRolesDisabled() && results.isEmpty()) {
                    MembershipQuery roleQuery = new MembershipQuery(query.isFindMembers(), query.getEntityToMatch(), query.getEntityNameToMatch(), EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE), query.getStartIndex(), query.getMaxResults(), query.getReturnType());
                    results = this.searchGroupRelationshipsWithGroupTypeSpecified(roleQuery);
                }
            } else {
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(query);
            }
        } else if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            GroupType groupTypeToReturn;
            GroupType groupTypeToMatch = query.getEntityToMatch().getGroupType();
            if (groupTypeToMatch != (groupTypeToReturn = query.getEntityToReturn().getGroupType())) {
                throw new IllegalArgumentException("Cannot search for group relationships of mismatching GroupTypes: attempted to match <" + groupTypeToMatch + "> and return <" + groupTypeToReturn + ">");
            }
            if (groupTypeToReturn == null) {
                MembershipQuery groupQuery = new MembershipQuery(query.isFindMembers(), EntityDescriptor.group((GroupType)GroupType.GROUP), query.getEntityNameToMatch(), EntityDescriptor.group((GroupType)GroupType.GROUP), query.getStartIndex(), query.getMaxResults(), query.getReturnType());
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(groupQuery);
                if (!this.ldapPropertiesMapper.isRolesDisabled() && results.isEmpty()) {
                    MembershipQuery roleQuery = new MembershipQuery(query.isFindMembers(), EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE), query.getEntityNameToMatch(), EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE), query.getStartIndex(), query.getMaxResults(), query.getReturnType());
                    results = this.searchGroupRelationshipsWithGroupTypeSpecified(roleQuery);
                }
            } else {
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(query);
            }
        } else {
            throw new IllegalArgumentException("Cannot search for relationships between a USER and another USER");
        }
        return results;
    }

    protected abstract List searchGroupRelationshipsWithGroupTypeSpecified(MembershipQuery var1);

    protected abstract String encodePassword(String var1) throws InvalidCredentialException;

    public boolean supportsNestedGroups() {
        return !this.ldapPropertiesMapper.isNestedGroupsDisabled();
    }

    public void testConnection() throws DirectoryAccessException {
        try {
            LdapContext ldapContext = (LdapContext)this.contextSource.getReadOnlyContext();
            ldapContext.getConnectControls();
        }
        catch (Exception e) {
            throw new DirectoryAccessException(e.getMessage());
        }
    }

    protected String getStandardisedDN(Name dn) {
        return DNStandardiser.standardise(new DistinguishedName(dn), !this.ldapPropertiesMapper.isRelaxedDnStandardisation());
    }

    protected LdapName asLdapName(String dn, Class objectType) throws ObjectNotFoundException {
        try {
            return new LdapName(dn);
        }
        catch (InvalidNameException e) {
            throw new ObjectNotFoundException(objectType, (Object)dn);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setLdapQueryTranslater(LDAPQueryTranslater ldapQueryTranslater) {
        this.ldapQueryTranslater = ldapQueryTranslater;
    }
}

