/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model.membership;

import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.InternalGroup;
import com.atlassian.crowd.integration.model.membership.MembershipType;
import com.atlassian.crowd.integration.model.user.InternalUser;
import com.atlassian.crowd.model.directory.Directory;
import java.io.Serializable;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class InternalMembership
implements Serializable {
    private Long id;
    private Long parentId;
    private Long childId;
    private MembershipType membershipType;
    private String parentName;
    private String lowerParentName;
    private String childName;
    private String lowerChildName;
    private GroupType groupType;
    private Directory directory;

    protected InternalMembership() {
    }

    public InternalMembership(Long id, Long parentId, Long childId, MembershipType membershipType, GroupType groupType, String parentName, String childName, Directory directory) {
        this.id = id;
        this.parentId = parentId;
        this.childId = childId;
        this.membershipType = membershipType;
        this.groupType = groupType;
        this.setParentName(parentName);
        this.setChildName(childName);
        this.directory = directory;
    }

    public InternalMembership(InternalGroup group, InternalUser user) {
        Validate.notNull((Object)group, (String)"group argument cannot be null");
        Validate.notNull((Object)user, (String)"user argument cannot be null");
        Validate.isTrue((boolean)group.getDirectoryId().equals(user.getDirectoryId()), (String)"directoryIDs of the user and group do not match");
        this.parentId = group.getId();
        this.childId = user.getId();
        this.membershipType = MembershipType.GROUP_USER;
        this.groupType = group.getType();
        this.setParentName(group.getName());
        this.setChildName(user.getName());
        this.directory = group.getDirectory();
    }

    public InternalMembership(InternalGroup parentGroup, InternalGroup childGroup) {
        Validate.notNull((Object)parentGroup, (String)"parentGroup argument cannot be null");
        Validate.notNull((Object)childGroup, (String)"childGroup argument cannot be null");
        Validate.isTrue((boolean)parentGroup.getDirectoryId().equals(childGroup.getDirectoryId()), (String)"directoryIDs of the parent and child group do not match");
        Validate.isTrue((boolean)parentGroup.getType().equals((Object)childGroup.getType()), (String)"groupTypes of the parent and child group do not match");
        this.parentId = parentGroup.getId();
        this.childId = childGroup.getId();
        this.membershipType = MembershipType.GROUP_GROUP;
        this.groupType = parentGroup.getType();
        this.setParentName(parentGroup.getName());
        this.setChildName(childGroup.getName());
        this.directory = parentGroup.getDirectory();
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public Long getChildId() {
        return this.childId;
    }

    public MembershipType getMembershipType() {
        return this.membershipType;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getChildName() {
        return this.childName;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public String getLowerParentName() {
        return this.lowerParentName;
    }

    public String getLowerChildName() {
        return this.lowerChildName;
    }

    private void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    private void setChildId(Long childId) {
        this.childId = childId;
    }

    private void setMembershipType(MembershipType membershipType) {
        this.membershipType = membershipType;
    }

    private void setParentName(String parentName) {
        this.parentName = parentName;
        this.lowerParentName = parentName.toLowerCase();
    }

    private void setChildName(String childName) {
        this.childName = childName;
        this.lowerChildName = childName.toLowerCase();
    }

    private void setDirectory(Directory directory) {
        this.directory = directory;
    }

    private void setGroupType(GroupType groupType) {
        this.groupType = groupType;
    }

    private void setLowerParentName(String lowerParentName) {
        this.lowerParentName = lowerParentName;
    }

    private void setLowerChildName(String lowerChildName) {
        this.lowerChildName = lowerChildName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalMembership)) {
            return false;
        }
        InternalMembership that = (InternalMembership)o;
        if (this.getChildId() != null ? !this.getChildId().equals(that.getChildId()) : that.getChildId() != null) {
            return false;
        }
        if (this.getParentId() != null ? !this.getParentId().equals(that.getParentId()) : that.getParentId() != null) {
            return false;
        }
        return this.getMembershipType() == that.getMembershipType();
    }

    public int hashCode() {
        int result = this.getParentId() != null ? this.getParentId().hashCode() : 0;
        result = 31 * result + (this.getChildId() != null ? this.getChildId().hashCode() : 0);
        result = 31 * result + (this.getMembershipType() != null ? this.getMembershipType().hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("parentId", (Object)this.getParentId()).append("childId", (Object)this.getChildId()).append("membershipType", (Object)this.getMembershipType()).append("groupType", (Object)this.getGroupType()).append("parentName", (Object)this.getParentName()).append("lowerParentName", (Object)this.getLowerParentName()).append("childName", (Object)this.getChildName()).append("lowerChildName", (Object)this.getLowerChildName()).append("directoryId", (Object)this.getDirectory().getId()).toString();
    }
}

