/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.config;

import com.atlassian.seraph.Initable;
import com.atlassian.seraph.SecurityService;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.seraph.auth.AuthenticationContextImpl;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.config.ConfigurationException;
import com.atlassian.seraph.config.DefaultLoginUrlStrategy;
import com.atlassian.seraph.config.DefaultRedirectPolicy;
import com.atlassian.seraph.config.LoginUrlStrategy;
import com.atlassian.seraph.config.RedirectPolicy;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.controller.SecurityController;
import com.atlassian.seraph.cookie.CookieFactory;
import com.atlassian.seraph.interceptor.Interceptor;
import com.atlassian.seraph.util.XMLUtils;
import com.opensymphony.util.ClassLoaderUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityConfigImpl
implements Serializable,
SecurityConfig {
    private static final Category log = Category.getInstance((Class)SecurityConfigImpl.class);
    private static SecurityConfigImpl instance = null;
    public static final String DEFAULT_CONFIG_LOCATION = "seraph-config.xml";
    private String configFileLocation = "seraph-config.xml";
    protected Authenticator authenticator = null;
    protected RoleMapper roleMapper = null;
    protected SecurityController controller;
    protected List services = null;
    protected List interceptors = null;
    private String loginURL;
    private String logoutURL;
    private String originalURLKey = "seraph_originalurl";
    private String cookieEncoding;
    private String loginCookieKey = "seraph.os.cookie";
    private String linkLoginURL;
    private String authType;
    private boolean insecureCookie;
    private int autoLoginCookieAge = 31536000;
    private LoginUrlStrategy loginUrlStrategy;
    private String loginCookiePath;
    private RedirectPolicy redirectPolicy;

    public SecurityConfigImpl(String configFileLocation) throws ConfigurationException {
        if (configFileLocation != null) {
            this.configFileLocation = configFileLocation;
            log.debug((Object)("Config file location passed.  Location: " + this.configFileLocation));
        } else {
            log.debug((Object)("Initialising securityConfig using default configFile: " + this.configFileLocation));
        }
        this.init();
    }

    private void init() throws ConfigurationException {
        this.services = new ArrayList();
        this.interceptors = new ArrayList();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            URL fileUrl = ClassLoaderUtil.getResource((String)this.configFileLocation, this.getClass());
            if (fileUrl == null) {
                throw new IllegalArgumentException("No such XML file: " + this.configFileLocation);
            }
            Document doc = factory.newDocumentBuilder().parse(fileUrl.toString());
            Element rootEl = doc.getDocumentElement();
            this.configureParameters(rootEl);
            this.configureAuthenticator(rootEl);
            this.configureController(rootEl);
            this.configureRoleMapper(rootEl);
            this.configureServices(rootEl);
            this.configureInterceptors(rootEl);
            this.configureLoginUrlStrategy(rootEl);
            this.configureRedirectPolicy(rootEl);
            CookieFactory.init(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationException("Exception configuring from '" + this.configFileLocation + "': " + e);
        }
    }

    protected void configureRedirectPolicy(Element rootEl) throws ConfigurationException {
        this.redirectPolicy = (RedirectPolicy)this.configureClass(rootEl, "redirect-policy");
        if (this.redirectPolicy == null) {
            this.redirectPolicy = new DefaultRedirectPolicy();
        }
    }

    protected void configureLoginUrlStrategy(Element rootEl) throws ConfigurationException {
        this.loginUrlStrategy = (LoginUrlStrategy)this.configureClass(rootEl, "login-url-strategy");
        if (this.loginUrlStrategy == null) {
            this.loginUrlStrategy = new DefaultLoginUrlStrategy();
        }
    }

    protected void configureAuthenticator(Element rootEl) throws ConfigurationException {
        this.authenticator = (Authenticator)this.configureClass(rootEl, "authenticator");
        try {
            if (this.authenticator == null) {
                this.authenticator = (Authenticator)ClassLoaderUtil.loadClass((String)"com.atlassian.seraph.auth.DefaultAuthenticator", this.getClass()).newInstance();
                this.authenticator.init(new HashMap(), this);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not lookup class: com.atlassian.seraph.auth.DefaultAuthenticator:" + e);
        }
    }

    protected void configureController(Element rootEl) throws ConfigurationException {
        this.controller = (SecurityController)this.configureClass(rootEl, "controller");
        try {
            if (this.controller == null) {
                this.controller = (SecurityController)ClassLoaderUtil.loadClass((String)SecurityController.NULL_CONTROLLER, this.getClass()).newInstance();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not lookup class: " + SecurityController.NULL_CONTROLLER + ":" + e);
        }
    }

    protected void configureRoleMapper(Element rootEl) throws ConfigurationException {
        this.roleMapper = (RoleMapper)this.configureClass(rootEl, "rolemapper");
    }

    private Initable configureClass(Element rootEl, String tagname) throws ConfigurationException {
        try {
            NodeList elementList = rootEl.getElementsByTagName(tagname);
            int i = 0;
            if (i < elementList.getLength()) {
                Element authEl = (Element)elementList.item(i);
                String clazz = authEl.getAttribute("class");
                Initable initable = (Initable)ClassLoaderUtil.loadClass((String)clazz, this.getClass()).newInstance();
                Map params = this.getInitParameters(authEl);
                initable.init(params, this);
                return initable;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create: " + tagname + ": " + e);
        }
        return null;
    }

    private void configureParameters(Element rootEl) {
        NodeList nl = rootEl.getElementsByTagName("parameters");
        Element parametersEl = (Element)nl.item(0);
        Map globalParams = this.getInitParameters(parametersEl);
        this.loginURL = (String)globalParams.get("login.url");
        this.linkLoginURL = (String)globalParams.get("link.login.url");
        this.logoutURL = (String)globalParams.get("logout.url");
        if (globalParams.get("original.url.key") != null) {
            this.originalURLKey = (String)globalParams.get("original.url.key");
        }
        if (globalParams.get("cookie.encoding") != null) {
            this.cookieEncoding = (String)globalParams.get("cookie.encoding");
        }
        if (globalParams.get("login.cookie.key") != null) {
            this.loginCookieKey = (String)globalParams.get("login.cookie.key");
        }
        if (globalParams.get("login.cookie.path") != null) {
            this.loginCookiePath = (String)globalParams.get("login.cookie.path");
        }
        if (globalParams.get("authentication.type") != null) {
            this.authType = (String)globalParams.get("authentication.type");
        }
        if (globalParams.get("autologin.cookie.age") != null) {
            this.autoLoginCookieAge = Integer.parseInt(globalParams.get("autologin.cookie.age").toString());
        }
        if (globalParams.get("insecure.cookie") != null) {
            this.insecureCookie = "true".equals(globalParams.get("insecure.cookie"));
        }
    }

    private void configureServices(Element rootEl) throws ConfigurationException {
        NodeList nl = rootEl.getElementsByTagName("services");
        if (nl != null && nl.getLength() > 0) {
            Element servicesEl = (Element)nl.item(0);
            NodeList serviceList = servicesEl.getElementsByTagName("service");
            for (int i = 0; i < serviceList.getLength(); ++i) {
                Element serviceEl = (Element)serviceList.item(i);
                String serviceClazz = serviceEl.getAttribute("class");
                if (serviceClazz == null || "".equals(serviceClazz)) {
                    throw new ConfigurationException("Service element with bad class attribute");
                }
                try {
                    log.debug((Object)("Adding seraph service of class: " + serviceClazz));
                    SecurityService service = (SecurityService)ClassLoaderUtil.loadClass((String)serviceClazz, this.getClass()).newInstance();
                    Map serviceParams = this.getInitParameters(serviceEl);
                    service.init(serviceParams, this);
                    this.services.add(service);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ConfigurationException("Could not getRequest service: " + serviceClazz + ". Exception: " + e);
                }
            }
        }
    }

    protected void configureInterceptors(Element rootEl) throws ConfigurationException {
        NodeList nl = rootEl.getElementsByTagName("interceptors");
        if (nl != null && nl.getLength() > 0) {
            Element interceptorsEl = (Element)nl.item(0);
            NodeList interceptorList = interceptorsEl.getElementsByTagName("interceptor");
            for (int i = 0; i < interceptorList.getLength(); ++i) {
                Element interceptorEl = (Element)interceptorList.item(i);
                String interceptorClazz = interceptorEl.getAttribute("class");
                if (interceptorClazz == null || "".equals(interceptorClazz)) {
                    throw new ConfigurationException("Interceptor element with bad class attribute");
                }
                try {
                    log.debug((Object)("Adding interceptor of class: " + interceptorClazz));
                    Interceptor interceptor = (Interceptor)ClassLoaderUtil.loadClass((String)interceptorClazz, this.getClass()).newInstance();
                    Map interceptorParams = this.getInitParameters(interceptorEl);
                    interceptor.init(interceptorParams, this);
                    this.interceptors.add(interceptor);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ConfigurationException("Could not getRequest service: " + interceptorClazz + ". Exception: " + e);
                }
            }
        }
    }

    protected Map getInitParameters(Element el) {
        HashMap<String, String> params = new HashMap<String, String>();
        NodeList nl = el.getElementsByTagName("init-param");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node initParam = nl.item(i);
            String paramName = XMLUtils.getContainedText(initParam, "param-name");
            String paramValue = XMLUtils.getContainedText(initParam, "param-value");
            params.put(paramName, paramValue);
        }
        return params;
    }

    public void destroy() {
        Iterator iterator = this.services.iterator();
        while (iterator.hasNext()) {
            SecurityService securityService = (SecurityService)iterator.next();
            securityService.destroy();
        }
        iterator = this.interceptors.iterator();
        while (iterator.hasNext()) {
            ((Interceptor)iterator.next()).destroy();
        }
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public List getServices() {
        return this.services;
    }

    public String getLoginURL() {
        return this.loginUrlStrategy.getLoginURL(this, this.loginURL);
    }

    public String getLinkLoginURL() {
        return this.loginUrlStrategy.getLinkLoginURL(this, this.linkLoginURL);
    }

    public String getLogoutURL() {
        return this.loginUrlStrategy.getLogoutURL(this, this.logoutURL);
    }

    public String getOriginalURLKey() {
        return this.originalURLKey;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public AuthenticationContext getAuthenticationContext() {
        return new AuthenticationContextImpl();
    }

    public SecurityController getController() {
        return this.controller;
    }

    public static SecurityConfigImpl getInstance(String configFileLocation) throws ConfigurationException {
        instance = new SecurityConfigImpl(configFileLocation);
        return instance;
    }

    public static SecurityConfig getInstance() {
        if (instance == null) {
            try {
                if (instance == null) {
                    instance = new SecurityConfigImpl(DEFAULT_CONFIG_LOCATION);
                }
            }
            catch (ConfigurationException e) {
                log.error((Object)("Could not configure SecurityConfigImpl instance: " + e), (Throwable)e);
            }
        }
        return instance;
    }

    public RoleMapper getRoleMapper() {
        return this.roleMapper;
    }

    public RedirectPolicy getRedirectPolicy() {
        return this.redirectPolicy;
    }

    public List getInterceptors(Class desiredInterceptorClass) {
        ArrayList<Interceptor> result = new ArrayList<Interceptor>();
        Iterator iterator = this.interceptors.iterator();
        while (iterator.hasNext()) {
            Interceptor interceptor = (Interceptor)iterator.next();
            if (!desiredInterceptorClass.isAssignableFrom(interceptor.getClass())) continue;
            result.add(interceptor);
        }
        return result;
    }

    public String getCookieEncoding() {
        return this.cookieEncoding;
    }

    public String getLoginCookiePath() {
        return this.loginCookiePath;
    }

    public String getLoginCookieKey() {
        return this.loginCookieKey;
    }

    public String getAuthType() {
        return this.authType;
    }

    public boolean isInsecureCookie() {
        return this.insecureCookie;
    }

    public int getAutoLoginCookieAge() {
        return this.autoLoginCookieAge;
    }
}

