/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.crowd.util.connector.LDAPPropertiesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask395
implements UpgradeTask {
    private DirectoryManager directoryManager;
    private LDAPPropertiesHelper ldapPropertiesHelper;
    private final Collection<String> errors = new ArrayList<String>();

    @Override
    public String getBuildNumber() {
        return "395";
    }

    @Override
    public String getShortDescription() {
        return "Setting use.relaxed.dn.stardisation to default values for all directory connectors";
    }

    @Override
    public void doUpgrade() throws Exception {
        List ldapDirectories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.CONNECTOR)).returningAtMost(-1));
        for (Directory directory : ldapDirectories) {
            String relaxed;
            Properties defaults = (Properties)this.ldapPropertiesHelper.getConfigurationDetails().get(directory.getImplementationClass());
            if (defaults == null || (relaxed = defaults.getProperty("ldap.relaxed.dn.standardisation")) == null) continue;
            directory.setAttribute("ldap.relaxed.dn.standardisation", relaxed);
            this.directoryManager.updateDirectory(directory);
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setLdapPropertiesHelper(LDAPPropertiesHelper ldapPropertiesHelper) {
        this.ldapPropertiesHelper = ldapPropertiesHelper;
    }
}

