/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.integration.directory.connector.MicrosoftActiveDirectory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UpgradeTask342
implements UpgradeTask {
    private DirectoryManager directoryManager;

    public String getBuildNumber() {
        return "342";
    }

    public String getShortDescription() {
        return "Adding 'useUserMembershipAttribute' and 'useUserMembershipAttributeForGroupMembership' defaults to non-internal directories";
    }

    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            if (directory.getType() == DirectoryType.INTERNAL) continue;
            directory.setAttribute("ldap.usermembership.use", Boolean.FALSE.toString());
            directory.setAttribute("ldap.usermembership.use.for.groups", Boolean.toString(this.isActiveDirectory(directory)));
            this.directoryManager.updateDirectory(directory);
        }
    }

    private boolean isActiveDirectory(Directory directory) {
        return MicrosoftActiveDirectory.class.getCanonicalName().equals(directory.getImplementationClass()) || MicrosoftActiveDirectory.class.getCanonicalName().equals(directory.getAttribute("crowd.delegated.directory.type"));
    }

    public Collection getErrors() {
        return Collections.EMPTY_LIST;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

