/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.crowd.util.I18nHelper;
import java.util.ArrayList;
import java.util.Collection;

public class UpgradeTask320
implements UpgradeTask {
    private Collection errors = new ArrayList();
    private ApplicationManager applicationManager;
    private I18nHelper i18nHelper;

    public String getBuildNumber() {
        return "320";
    }

    public String getShortDescription() {
        return "Updating application descriptions and types for Crowd's default applications";
    }

    public void doUpgrade() throws Exception {
        String crowdName = this.i18nHelper.getText("application.name").toLowerCase();
        String crowdDesc = this.i18nHelper.getText("application.description");
        String demoName = this.i18nHelper.getText("demo.application.name");
        String demoDesc = this.i18nHelper.getText("demo.application.description");
        String openidName = this.i18nHelper.getText("crowdid.application.name");
        String openidDesc = this.i18nHelper.getText("crowdid.application.description");
        this.updateApplication(crowdName, crowdDesc, ApplicationType.CROWD, true);
        this.updateApplication(demoName, demoDesc, ApplicationType.GENERIC_APPLICATION, false);
        this.updateApplication(openidName, openidDesc, ApplicationType.GENERIC_APPLICATION, false);
    }

    private boolean updateApplication(String applicationName, String newDescription, ApplicationType newType, boolean required) {
        try {
            Application app = this.applicationManager.findByName(applicationName);
            app.setDescription(newDescription);
            app.setType(newType);
            this.applicationManager.update(app);
            return true;
        }
        catch (ObjectNotFoundException e) {
            if (required) {
                this.errors.add("Could not find application to update: " + applicationName);
            }
            return false;
        }
        catch (ApplicationManagerException e) {
            this.errors.add("Could not update found application: " + applicationName);
            return false;
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }
}

