/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.directory.connector.SpringLDAPConnector;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UpgradeTask112
implements UpgradeTask {
    private static final String BUILD_NUMBER = "112";
    private List errors = new ArrayList();
    private DirectoryManager directoryManager;

    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public String getShortDescription() {
        return "Adds missing paged results option to the LDAP connectors.";
    }

    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            Map attributes;
            RemoteDirectory directoryImpl = directory.getImplementation();
            if (directoryImpl instanceof SpringLDAPConnector && !(attributes = directory.getAttributes()).containsKey("ldap.pagedresults")) {
                directory.setAttribute("ldap.pagedresults", Boolean.toString(false));
            }
            this.directoryManager.updateDirectory(directory);
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

