/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.upgrade.UpgradeManager;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.spring.container.ContainerManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeManagerImpl
implements UpgradeManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private CrowdBootstrapManager bootstrapManager;
    private PropertyManager propertyManager;
    private SessionFactory sessionFactory;
    private CacheManager cacheManager;
    private String fileName;

    protected int getApplicationBuildNumber() {
        return Integer.parseInt("411");
    }

    @Override
    public int getDataBuildNumber() {
        int buildNumber;
        try {
            buildNumber = this.propertyManager.getBuildNumber();
        }
        catch (PropertyManagerException e) {
            buildNumber = 0;
        }
        return buildNumber;
    }

    @Override
    public List<UpgradeTask> getRequiredUpgrades() {
        ArrayList<UpgradeTask> requiredUpgrades = new ArrayList<UpgradeTask>();
        int currentBuildNumber = this.getDataBuildNumber();
        int finalBuildNumber = this.getApplicationBuildNumber();
        try {
            Document xmlDoc = this.getUpgradeDocument();
            Element root = xmlDoc.getRootElement();
            List actions = root.elements("upgrade");
            for (Element action : actions) {
                String className = action.element("class").getText();
                String build = action.attribute("build").getValue();
                int upgradeTaskBuildNumber = Integer.parseInt(build);
                if (upgradeTaskBuildNumber <= currentBuildNumber || upgradeTaskBuildNumber > finalBuildNumber) continue;
                try {
                    UpgradeTask task = (UpgradeTask)ClassLoaderUtils.loadClass((String)className, this.getClass()).newInstance();
                    this.autowireTask(task);
                    requiredUpgrades.add(task);
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                }
            }
        }
        catch (DocumentException e) {
            this.logger.fatal((Object)e, (Throwable)e);
        }
        return requiredUpgrades;
    }

    @Override
    public boolean needUpgrade() {
        return this.getApplicationBuildNumber() != this.getDataBuildNumber();
    }

    @Override
    public Collection<String> doUpgrade() throws Exception {
        String lastSuccessfullyRanUpgrade = null;
        ArrayList<String> errors = new ArrayList<String>();
        if (this.needUpgrade()) {
            for (UpgradeTask task : this.getRequiredUpgrades()) {
                this.logger.info((Object)("Running upgrade task for build - " + task.getBuildNumber() + ": " + task.getShortDescription()));
                try {
                    task.doUpgrade();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    errors.add("Upgrade task for build " + task.getBuildNumber() + " failed with exception: " + e.getMessage());
                }
                if (!task.getErrors().isEmpty()) {
                    errors.addAll(task.getErrors());
                    break;
                }
                if (!errors.isEmpty()) continue;
                lastSuccessfullyRanUpgrade = task.getBuildNumber();
            }
            if (errors.isEmpty()) {
                this.setCurrentBuildNumber(this.getApplicationBuildNumber());
            } else if (lastSuccessfullyRanUpgrade != null) {
                this.setCurrentBuildNumber(Integer.parseInt(lastSuccessfullyRanUpgrade));
            }
            this.flushAndClearHibernate();
        }
        return errors;
    }

    protected void flushAndClearHibernate() {
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        this.cacheManager.clearAll();
    }

    private void setCurrentBuildNumber(int buildNumber) {
        try {
            this.propertyManager.setBuildNumber(Integer.valueOf(buildNumber));
            this.getBootstrapManager().setBuildNumber(Integer.toString(buildNumber));
            this.getBootstrapManager().save();
        }
        catch (ConfigurationException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Document getUpgradeDocument() throws DocumentException {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)this.fileName, this.getClass());
        SAXReader saxReader = new SAXReader();
        Document xmlDoc = saxReader.read(is);
        try {
            is.close();
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        return xmlDoc;
    }

    protected void autowireTask(UpgradeTask upgradeTask) {
        ContainerManager.autowireComponent((Object)upgradeTask);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public CrowdBootstrapManager getBootstrapManager() {
        if (this.bootstrapManager == null) {
            this.bootstrapManager = (CrowdBootstrapManager)BootstrapUtils.getBootstrapManager();
        }
        return this.bootstrapManager;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

