/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.util.concurrent.CopyOnWriteMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginPersistentState
implements Serializable,
PluginPersistentState {
    private final Map<String, Boolean> map;
    private static final String RESTART_STATE_SEPARATOR = "--";

    public DefaultPluginPersistentState() {
        this(Collections.emptyMap());
    }

    public DefaultPluginPersistentState(Map<String, Boolean> map) {
        this.map = CopyOnWriteMap.newHashMap(map);
    }

    public DefaultPluginPersistentState(PluginPersistentState state) {
        this.map = CopyOnWriteMap.newHashMap(state.getMap());
    }

    public Boolean getState(String key) {
        return this.map.get(key);
    }

    @Override
    public Map<String, Boolean> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public boolean isEnabled(Plugin plugin) {
        Boolean bool = this.getState(plugin.getKey());
        return bool == null ? plugin.isEnabledByDefault() : bool.booleanValue();
    }

    @Override
    public boolean isEnabled(ModuleDescriptor<?> pluginModule) {
        if (pluginModule == null) {
            return false;
        }
        Boolean bool = this.getState(pluginModule.getCompleteKey());
        return bool == null ? pluginModule.isEnabledByDefault() : bool.booleanValue();
    }

    public void setEnabled(ModuleDescriptor<?> pluginModule, boolean isEnabled) {
        this.setEnabled(pluginModule.getCompleteKey(), pluginModule.isEnabledByDefault(), isEnabled);
    }

    public void setEnabled(Plugin plugin, boolean isEnabled) {
        this.setEnabled(plugin.getKey(), plugin.isEnabledByDefault(), isEnabled);
    }

    private void setEnabled(String completeKey, boolean enabledByDefault, boolean isEnabled) {
        if (isEnabled == enabledByDefault) {
            this.map.remove(completeKey);
        } else {
            this.map.put(completeKey, isEnabled);
        }
    }

    public void setState(PluginPersistentState state) {
        this.map.clear();
        this.map.putAll(state.getMap());
    }

    public void addState(Map<String, Boolean> state) {
        this.map.putAll(state);
    }

    public void removeState(String key) {
        this.map.remove(key);
    }

    @Override
    public Map<String, Boolean> getPluginStateMap(Plugin plugin) {
        HashMap<String, Boolean> state = new HashMap<String, Boolean>(this.getMap());
        CollectionUtils.filter(state.keySet(), (Predicate)new StringStartsWith(plugin.getKey()));
        return state;
    }

    @Override
    public PluginRestartState getPluginRestartState(String pluginKey) {
        for (PluginRestartState state : PluginRestartState.values()) {
            if (!this.map.containsKey(DefaultPluginPersistentState.buildStateKey(pluginKey, state))) continue;
            return state;
        }
        return PluginRestartState.NONE;
    }

    public void setPluginRestartState(String pluginKey, PluginRestartState state) {
        for (PluginRestartState st : PluginRestartState.values()) {
            this.map.remove(DefaultPluginPersistentState.buildStateKey(pluginKey, st));
        }
        if (state != PluginRestartState.NONE) {
            this.map.put(DefaultPluginPersistentState.buildStateKey(pluginKey, state), true);
        }
    }

    private static String buildStateKey(String pluginKey, PluginRestartState state) {
        StringBuilder sb = new StringBuilder();
        sb.append(state.name());
        sb.append(RESTART_STATE_SEPARATOR);
        sb.append(pluginKey);
        return sb.toString();
    }

    public void clearPluginRestartState() {
        HashSet<String> keys = new HashSet<String>(this.getMap().keySet());
        for (String key : keys) {
            if (!key.contains(RESTART_STATE_SEPARATOR)) continue;
            this.map.remove(key);
        }
    }

    private static class StringStartsWith
    implements Predicate {
        private final String prefix;

        public StringStartsWith(String keyPrefix) {
            this.prefix = keyPrefix;
        }

        public boolean evaluate(Object object) {
            String str = (String)object;
            return str.startsWith(this.prefix);
        }
    }
}

