/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.model.GroupMembership;
import com.atlassian.crowd.importer.model.MembershipDTO;
import com.atlassian.crowd.importer.model.Result;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseImporter
implements Importer {
    protected final Logger logger = Logger.getLogger(BaseImporter.class);
    protected final DirectoryManager directoryManager;

    public BaseImporter(DirectoryManager directoryManager) {
        if (directoryManager == null) {
            throw new IllegalArgumentException("DirectoryManager cannot be null");
        }
        this.directoryManager = directoryManager;
    }

    protected Result importGroups(Collection<GroupTemplate> groups, Configuration configuration) throws ImporterException {
        Result importResult = new Result();
        if (groups != null) {
            this.logger.info((Object)("Importing " + groups.size() + " groups."));
            for (GroupTemplate group : groups) {
                group.setDirectoryId(configuration.getDirectoryID());
            }
            try {
                BulkAddResult opResult = this.directoryManager.addAllGroups(configuration.getDirectoryID().longValue(), groups, configuration.isOverwriteTarget().booleanValue());
                importResult.setGroupsImported(opResult.getAddedSuccessfully());
                for (Group entity : opResult.getFailedEntities()) {
                    importResult.addGroupFailedImport(entity.getName());
                }
                for (Group entity : opResult.getExistingEntities()) {
                    importResult.addExistingGroup(entity.getName());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Error attempting to bulk import roles into directory with ID: " + configuration.getDirectoryID()), (Throwable)e);
                throw new ImporterException(e);
            }
        }
        return importResult;
    }

    protected Result importUsers(Collection<UserTemplateWithCredentialAndAttributes> users, Configuration configuration) throws ImporterException {
        Result importResult = new Result();
        if (users != null) {
            this.logger.info((Object)("Importing " + users.size() + " users."));
            for (UserTemplateWithCredentialAndAttributes user : users) {
                user.setDirectoryId(configuration.getDirectoryID());
            }
            try {
                BulkAddResult opResult = this.directoryManager.addAllUsers(configuration.getDirectoryID().longValue(), users, configuration.isOverwriteTarget().booleanValue());
                importResult.setUsersImported(opResult.getAddedSuccessfully());
                for (User entity : opResult.getFailedEntities()) {
                    importResult.addUsersFailedImport(entity.getName());
                }
                for (User entity : opResult.getExistingEntities()) {
                    importResult.addExistingUser(entity.getName());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Error attempting to bulk import principals into directory with ID: " + configuration.getDirectoryID()), (Throwable)e);
                throw new ImporterException(e);
            }
        }
        return importResult;
    }

    private Map<String, Collection<String>> mapContainersToUsers(Collection<? extends MembershipDTO> memberships) {
        HashMap<String, Collection<String>> containerToPrincipals = new HashMap<String, Collection<String>>();
        for (MembershipDTO membershipDTO : memberships) {
            if (containerToPrincipals.get(membershipDTO.getContainerName()) == null) {
                containerToPrincipals.put(membershipDTO.getContainerName(), new ArrayList());
            }
            ((Collection)containerToPrincipals.get(membershipDTO.getContainerName())).add(membershipDTO.getUsername());
        }
        return containerToPrincipals;
    }

    protected Result importGroupMemberships(Collection<GroupMembership> memberships, Configuration configuration) throws ImporterException {
        Result importResult = new Result();
        if (memberships != null) {
            this.logger.info((Object)("Importing " + memberships.size() + " group memberships."));
            Map<String, Collection<String>> groupToPrincipalsMap = this.mapContainersToUsers(memberships);
            try {
                for (Map.Entry<String, Collection<String>> groupAndMembers : groupToPrincipalsMap.entrySet()) {
                    try {
                        BulkAddResult opResult = this.directoryManager.addAllUsersToGroup(configuration.getDirectoryID().longValue(), groupAndMembers.getValue(), groupAndMembers.getKey());
                        importResult.addFailedGroupMembershipImports(groupAndMembers.getKey(), opResult.getFailedEntities());
                        importResult.addGroupMembershipsImported(opResult.getAddedSuccessfully());
                    }
                    catch (ObjectNotFoundException e) {
                        this.logger.error((Object)("Could not add memberships for group '" + groupAndMembers.getKey() + "' as it does not exist in directory with ID: " + configuration.getDirectoryID()), (Throwable)e);
                        importResult.addFailedGroupMembershipImports(groupAndMembers.getKey(), groupAndMembers.getValue());
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Error attempting to bulk import group relationships into directory with ID: " + configuration.getDirectoryID()), (Throwable)e);
                throw new ImporterException(e);
            }
        }
        return importResult;
    }

    @Override
    public Result importUsersGroupsAndMemberships(Configuration configuration) throws ImporterException {
        Collection<GroupMembership> groupMemberships;
        Collection<UserTemplateWithCredentialAndAttributes> users;
        if (configuration == null || !this.getConfigurationType().isInstance(configuration)) {
            throw new IllegalArgumentException("The supplied configuration was of the incorrect type for this Importer, should of been: " + this.getConfigurationType().getCanonicalName());
        }
        this.init(configuration);
        Result finalImportResult = new Result();
        Collection<GroupTemplate> groups = this.findGroups(configuration);
        if (groups != null && !groups.isEmpty()) {
            Result groupsResult = this.importGroups(groups, configuration);
            finalImportResult.setGroupsImported(groupsResult.getGroupsImported());
            finalImportResult.setGroupsFailedImport(groupsResult.getGroupsFailedImport());
        }
        if ((users = this.findUsers(configuration)) != null && !users.isEmpty()) {
            Result usersResult = this.importUsers(users, configuration);
            finalImportResult.setUsersImported(usersResult.getUsersImported());
            finalImportResult.setUsersFailedImport(usersResult.getUsersFailedImport());
        }
        if ((groupMemberships = this.findGroupMemberships(configuration)) != null && !groupMemberships.isEmpty()) {
            Result membershipResult = this.importGroupMemberships(groupMemberships, configuration);
            finalImportResult.setGroupMembershipsImported(membershipResult.getGroupMembershipsImported());
            finalImportResult.setGroupMembershipsFailedImport(membershipResult.getGroupMembershipsFailedImport());
        }
        return finalImportResult;
    }
}

