/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.cache.CacheFactoryAware;
import com.atlassian.user.impl.hibernate.DefaultExternalEntityDAO;
import com.atlassian.user.impl.hibernate.DefaultHibernateExternalEntity;
import java.io.Serializable;

public class CachingExternalEntityDAO
extends DefaultExternalEntityDAO
implements CacheFactoryAware {
    private CacheFactory cacheFactory;

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public ExternalEntity getExternalEntity(String externalEntityName) {
        Cache nameCache = this.cacheFactory.getCache(this.getClass().getName() + ".externalEntityName");
        Long id = (Long)nameCache.get((Object)externalEntityName);
        if (id != null) {
            return (ExternalEntity)this.getHibernateTemplate().get(DefaultHibernateExternalEntity.class, (Serializable)id);
        }
        ExternalEntity externalEntity = super.getExternalEntity(externalEntityName);
        if (externalEntity != null) {
            nameCache.put((Object)externalEntityName, (Object)new Long(externalEntity.getId()));
        }
        return externalEntity;
    }

    public void removeExternalEntity(String externalEntityName) {
        Cache nameCache = this.cacheFactory.getCache(this.getClass().getName() + ".externalEntityName");
        nameCache.remove((Object)externalEntityName);
        super.removeExternalEntity(externalEntityName);
    }
}

