/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

final class XMLConfigUtil {
    private XMLConfigUtil() {
    }

    public static HashMap parseRepositoryElementForClassNames(Element repositoryElement) {
        HashMap<String, String> values = new HashMap<String, String>();
        Element classesElement = repositoryElement.element("classes");
        if (classesElement == null) {
            return values;
        }
        List subElements = classesElement.elements();
        Iterator iter = subElements.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            if (element.getName().equals("param")) {
                Attribute paramAttribute = element.attribute("name");
                values.put(paramAttribute.getText(), element.getText());
                continue;
            }
            values.put(element.getName(), element.getText());
        }
        Attribute attr = repositoryElement.attribute("class");
        if (attr != null) {
            values.put("class", attr.getText());
        }
        return values;
    }

    public static Map parseRepositoryElementForStringData(Element repositoryElement) {
        HashMap<String, String> values = new HashMap<String, String>();
        Iterator attributeIterator = repositoryElement.attributes().iterator();
        while (attributeIterator.hasNext()) {
            Attribute attr = (Attribute)attributeIterator.next();
            if (attr.getName().equals("class")) continue;
            values.put(attr.getName(), attr.getText());
        }
        Iterator elementIterator = repositoryElement.elements().iterator();
        while (elementIterator.hasNext()) {
            Element element = (Element)elementIterator.next();
            if (element.getName().equals("classes")) continue;
            values.put(element.getName(), element.getText());
        }
        return values;
    }
}

