/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.lifecycle;

import com.atlassian.config.lifecycle.LifecycleItem;
import com.atlassian.config.lifecycle.ServletContextListenerWrapper;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.spring.container.ContainerManager;
import javax.servlet.ServletContextListener;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class LifecyclePluginModuleDescriptor
extends AbstractModuleDescriptor
implements Comparable,
StateAware {
    private Object module;
    private int sequence;

    public LifecyclePluginModuleDescriptor() {
    }

    LifecyclePluginModuleDescriptor(Object module, int sequence) {
        this.module = module;
        this.sequence = sequence;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.sequence = this.determineSequenceNumber(element);
        this.ensureCompatibleModuleType();
    }

    private void ensureCompatibleModuleType() throws PluginParseException {
        Class moduleClass;
        if (!LifecycleItem.class.isAssignableFrom(moduleClass = this.getModuleClass()) && !ServletContextListener.class.isAssignableFrom(moduleClass)) {
            throw new PluginParseException("Lifecycle classes must extend LifecycleItem or ServletContextListener. Module class: " + moduleClass.getName());
        }
    }

    private int determineSequenceNumber(Element element) throws PluginParseException {
        Attribute att = element.attribute("sequence");
        if (att != null) {
            String value = att.getValue();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new PluginParseException("Could not determine sequence from: " + value);
            }
        }
        throw new PluginParseException("Missing required attribute: sequence");
    }

    public Object getModule() {
        if (this.module == null) {
            this.module = this.makeModule();
        }
        return this.module;
    }

    private Object makeModule() {
        Object module = ContainerManager.getInstance().getContainerContext().createComponent(this.getModuleClass());
        if (module instanceof ServletContextListener) {
            module = new ServletContextListenerWrapper((ServletContextListener)module);
        }
        return module;
    }

    public void enabled() {
        if (this.getModule() instanceof StateAware) {
            ((StateAware)this.getModule()).enabled();
        }
    }

    public void disabled() {
        if (this.getModule() instanceof StateAware) {
            ((StateAware)this.getModule()).disabled();
        }
    }

    public int getSequence() {
        return this.sequence;
    }

    public int compareTo(Object o) {
        int otherSequence = ((LifecyclePluginModuleDescriptor)o).sequence;
        return this.sequence == otherSequence ? 0 : (this.sequence < otherSequence ? -1 : 1);
    }
}

