/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util.thumbnail;

import com.atlassian.core.util.ImageInfo;
import com.atlassian.core.util.thumbnail.SimpleImageConsumer;
import com.atlassian.core.util.thumbnail.Thumbnail;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thumber {
    private static final Logger log = Logger.getLogger(Thumber.class);
    private ImageInfo imageInfo = new ImageInfo();
    public static final List<String> THUMBNAIL_MIME_TYPES = Collections.unmodifiableList(Arrays.asList(ImageIO.getReaderMIMETypes()));
    public static final List<String> THUMBNAIL_FORMATS = Collections.unmodifiableList(Arrays.asList(ImageIO.getReaderFormatNames()));
    private float encodingQuality = 0.8f;

    public static List<String> getThumbnailMimeTypes() {
        return THUMBNAIL_MIME_TYPES;
    }

    public static List<String> getThumbnailFormats() {
        return THUMBNAIL_FORMATS;
    }

    public boolean checkToolkit() {
        try {
            Toolkit.getDefaultToolkit();
        }
        catch (Throwable e) {
            log.error((Object)"Unable to acquire AWT default toolkit - thumbnails will not be displayed. Check DISPLAY variable or use setting -Djava.awt.headless=true.", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thumbnail retrieveOrCreateThumbNail(File originalFile, File thumbnailFile, int maxWidth, int maxHeight, long thumbnailId) throws MalformedURLException {
        FileInputStream originalFileStream = null;
        try {
            originalFileStream = new FileInputStream(originalFile);
            Thumbnail thumbnail = this.retrieveOrCreateThumbNail(originalFileStream, originalFile.getName(), thumbnailFile, maxWidth, maxHeight, thumbnailId);
            return thumbnail;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Unable to create thumbnail: file not found: " + originalFile.getAbsolutePath()));
        }
        finally {
            try {
                originalFileStream.close();
            }
            catch (IOException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeImage(BufferedImage scaledImage, File file) throws FileNotFoundException {
        if (scaledImage == null) {
            log.warn((Object)"Can't store a null scaledImage.");
            return;
        }
        FileImageOutputStream fout = null;
        try {
            fout = new FileImageOutputStream(file);
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(this.encodingQuality);
            writer.setOutput(fout);
            writer.write(null, new IIOImage(scaledImage, null, null), param);
        }
        catch (IOException e) {
            log.error((Object)"Error encoding the thumbnail image", (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public BufferedImage scaleImage(Image imageToScale, WidthHeightHelper newDimensions) {
        BufferedImage bufferedImage;
        if (imageToScale instanceof BufferedImage && !(bufferedImage = (BufferedImage)imageToScale).getColorModel().getColorSpace().isCS_sRGB()) {
            BufferedImage sRGBImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
            Graphics g = sRGBImage.getGraphics();
            g.drawImage(bufferedImage, 0, 0, null);
            g.dispose();
            imageToScale = sRGBImage;
        }
        AreaAveragingScaleFilter scaleFilter = new AreaAveragingScaleFilter(newDimensions.getWidth(), newDimensions.getHeight());
        FilteredImageSource producer = new FilteredImageSource(imageToScale.getSource(), scaleFilter);
        SimpleImageConsumer generator = new SimpleImageConsumer();
        producer.startProduction(generator);
        BufferedImage scaled = generator.getImage();
        if (scaled == null) {
            log.warn((Object)"Unabled to create scaled image.");
        } else {
            scaled.flush();
        }
        return scaled;
    }

    public Thumbnail retrieveOrCreateThumbNail(InputStream originalFileStream, String fileName, File thumbnailFile, int maxWidth, int maxHeight, long thumbnailId) throws MalformedURLException {
        Thumbnail thumbnail = null;
        try {
            thumbnail = this.getThumbnail(thumbnailFile, fileName, thumbnailId);
        }
        catch (IOException e) {
            log.error((Object)("Unable to get thumbnail image for id " + thumbnailId), (Throwable)e);
            return null;
        }
        if (thumbnail == null) {
            try {
                thumbnail = this.createThumbnail(originalFileStream, thumbnailFile, maxWidth, maxHeight, thumbnailId, fileName);
            }
            catch (IOException e) {
                log.error((Object)("Unable to create thumbnail image for id " + thumbnailId), (Throwable)e);
                return null;
            }
        }
        return thumbnail;
    }

    private BufferedImage scaleImage(Image originalImage, int maxWidth, int maxHeight) {
        return this.scaleImage(originalImage, this.determineScaleSize(maxWidth, maxHeight, originalImage));
    }

    private WidthHeightHelper determineScaleSize(int maxWidth, int maxHeight, Image image) {
        return this.determineScaleSize(maxWidth, maxHeight, image.getWidth(null), image.getHeight(null));
    }

    private Thumbnail createThumbnail(InputStream originalFile, File thumbnailFile, int maxWidth, int maxHeight, long thumbId, String fileName) throws IOException, FileNotFoundException {
        Image originalImage = this.getImage(originalFile);
        BufferedImage scaledImage = this.scaleImage(originalImage, maxWidth, maxHeight);
        int height = scaledImage.getHeight();
        int width = scaledImage.getWidth();
        this.storeImage(scaledImage, thumbnailFile);
        return new Thumbnail(height, width, fileName, thumbId);
    }

    private Thumbnail getThumbnail(File thumbnailFile, String filename, long thumbId) throws IOException {
        if (thumbnailFile.exists()) {
            Image thumbImage = this.getImage(thumbnailFile);
            return new Thumbnail(thumbImage.getHeight(null), thumbImage.getWidth(null), filename, thumbId);
        }
        return null;
    }

    public Image getImage(File file) throws IOException {
        return ImageIO.read(file);
    }

    public Image getImage(InputStream is) throws IOException {
        return ImageIO.read(is);
    }

    public void setEncodingQuality(float f) {
        if (f > 1.0f || f < 0.0f) {
            throw new IllegalArgumentException("Invalid quality setting '" + f + "', value must be between 0 and 1. ");
        }
        this.encodingQuality = f;
    }

    public WidthHeightHelper determineScaleSize(int maxWidth, int maxHeight, int imageWidth, int imageHeight) {
        if (maxHeight > imageHeight && maxWidth > imageWidth) {
            return new WidthHeightHelper(imageWidth, imageHeight);
        }
        double thumbRatio = (double)maxWidth / (double)maxHeight;
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (thumbRatio < imageRatio) {
            return new WidthHeightHelper(maxWidth, (int)((double)maxWidth / imageRatio));
        }
        return new WidthHeightHelper((int)((double)maxHeight * imageRatio), maxHeight);
    }

    public boolean isFileSupportedImage(File file) {
        try {
            return this.isFileSupportedImage(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileSupportedImage(InputStream inputStream) {
        try {
            this.imageInfo.setInput(inputStream);
            this.imageInfo.check();
            for (String format : THUMBNAIL_FORMATS) {
                if (!format.equalsIgnoreCase(this.imageInfo.getFormatName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public static class WidthHeightHelper {
        private int width;
        private int height;

        public WidthHeightHelper(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }
}

