/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.service.AuthenticationManager;
import com.atlassian.crowd.integration.service.soap.client.ClientProperties;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPCookieInfo;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class HttpAuthenticatorImpl
implements HttpAuthenticator {
    private static final Logger logger = Logger.getLogger(HttpAuthenticatorImpl.class);
    private final AuthenticationManager authenticationManager;

    public HttpAuthenticatorImpl(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    private void invalidateClient(HttpServletRequest request, HttpServletResponse response, String token) throws InvalidAuthorizationTokenException, RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invalidating the Crowd token: " + token));
        }
        HttpSession session = request.getSession();
        session.removeAttribute(this.getClientProperties().getSessionTokenKey());
        request.removeAttribute(this.getCookieTokenKey());
        if (response != null) {
            Cookie tokenCookie = this.buildCookie(token);
            tokenCookie.setMaxAge(0);
            response.addCookie(tokenCookie);
        }
    }

    public void setPrincipalToken(HttpServletRequest request, HttpServletResponse response, String token) throws InvalidAuthorizationTokenException, RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting the Crowd token: " + token));
        }
        HttpSession session = request.getSession();
        session.setAttribute(this.getClientProperties().getSessionLastValidation(), (Object)new Date());
        request.setAttribute(this.getCookieTokenKey(), (Object)token);
        if (response != null && request.getAttribute(REQUEST_SSO_COOKIE_COMMITTED) == null) {
            Cookie tokenCookie = this.buildCookie(token);
            response.addCookie(tokenCookie);
            request.setAttribute(REQUEST_SSO_COOKIE_COMMITTED, (Object)Boolean.TRUE);
        }
    }

    public SOAPPrincipal getPrincipal(HttpServletRequest request) throws InvalidAuthorizationTokenException, RemoteException, ObjectNotFoundException, InvalidTokenException {
        return this.getSecurityServerClient().findPrincipalByToken(this.getToken(request));
    }

    public String getToken(HttpServletRequest request) throws InvalidTokenException {
        String token;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Checking for a SSO token that will need to be verified by Crowd.");
        }
        if ((token = (String)request.getAttribute(this.getCookieTokenKey())) == null) {
            Cookie[] cookies;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No request header token could be found, now checking the browser submitted cookies.");
            }
            if ((cookies = request.getCookies()) != null && cookies.length > 0) {
                for (int i = 0; i < cookies.length; ++i) {
                    Cookie cookie = cookies[i];
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Cookie name/value: " + cookie.getName() + " / " + cookie.getValue()));
                    }
                    if (!this.getCookieTokenKey().equals(cookie.getName()) || cookie.getValue() == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Accepting the SSO cookie value: " + cookie.getValue()));
                    }
                    token = cookie.getValue();
                    break;
                }
            }
        }
        if (token == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to find a valid Crowd token.");
            }
            throw new InvalidTokenException("Unable to find a valid principal token.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Existing token value yet to be verified by Crowd: " + token));
        }
        return token;
    }

    public boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) throws InvalidAuthorizationTokenException, RemoteException, ApplicationAccessDeniedException {
        long timeSpread;
        String token;
        HttpSession session = request.getSession();
        try {
            token = this.getToken(request);
        }
        catch (InvalidTokenException e) {
            logger.debug((Object)"Non authenticated request, unable to find a valid Crowd token.");
            return false;
        }
        Date lastValidation = (Date)session.getAttribute(this.getClientProperties().getSessionLastValidation());
        if (lastValidation != null && this.getClientProperties().getSessionValidationInterval() > 0L && (timeSpread = lastValidation.getTime() + 60000L * this.getClientProperties().getSessionValidationInterval()) > System.currentTimeMillis()) {
            return true;
        }
        if (this.authenticationManager.isAuthenticated(token, this.getValidationFactors(request))) {
            this.setPrincipalToken(request, response, token);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(HttpServletRequest request, HttpServletResponse response, String username, String password) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException {
        block5: {
            String token;
            block4: {
                token = null;
                try {
                    UserAuthenticationContext userAuthenticationContext = this.getPrincipalAuthenticationContext(request, response, username, password);
                    token = this.authenticationManager.authenticate(userAuthenticationContext);
                    if (token != null) break block4;
                }
                catch (Throwable throwable) {
                    if (token == null) {
                        this.invalidateClient(request, response, null);
                    } else {
                        this.setPrincipalToken(request, response, token);
                    }
                    throw throwable;
                }
                this.invalidateClient(request, response, null);
                break block5;
            }
            this.setPrincipalToken(request, response, token);
        }
    }

    public String verifyAuthentication(String username, String password, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException {
        PasswordCredential credential = new PasswordCredential(password);
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext();
        userAuthenticationContext.setApplication(this.getClientProperties().getApplicationName());
        userAuthenticationContext.setCredential(credential);
        userAuthenticationContext.setName(username);
        userAuthenticationContext.setValidationFactors(validationFactors);
        return this.authenticationManager.authenticate(userAuthenticationContext);
    }

    public void verifyAuthentication(String username, String password) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException {
        this.authenticationManager.authenticate(username, password);
    }

    public ValidationFactor[] getValidationFactors(HttpServletRequest request) {
        ArrayList<ValidationFactor> validationFactors = new ArrayList<ValidationFactor>();
        if (request != null) {
            String agent;
            String remoteAddressXForwardFor;
            String remoteAddress = request.getRemoteAddr();
            if (remoteAddress != null && remoteAddress.length() > 0) {
                validationFactors.add(new ValidationFactor("remote_address", remoteAddress));
            }
            if ((remoteAddressXForwardFor = request.getHeader("X-Forwarded-For")) != null && !remoteAddressXForwardFor.equals(remoteAddress)) {
                validationFactors.add(new ValidationFactor("X-Forwarded-For", remoteAddressXForwardFor));
            }
            if ((agent = request.getHeader("User-Agent")) != null && agent.length() > 0) {
                validationFactors.add(new ValidationFactor("User-Agent", agent));
            }
        }
        return validationFactors.toArray(new ValidationFactor[validationFactors.size()]);
    }

    public void logoff(HttpServletRequest request, HttpServletResponse response) throws InvalidAuthorizationTokenException, RemoteException {
        String token = null;
        try {
            token = this.getToken(request);
            this.authenticationManager.invalidate(token);
        }
        catch (InvalidTokenException e) {
            // empty catch block
        }
        this.invalidateClient(request, response, token);
    }

    public UserAuthenticationContext getPrincipalAuthenticationContext(HttpServletRequest request, HttpServletResponse response, String username, String password) {
        PasswordCredential credential = new PasswordCredential(password);
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext();
        userAuthenticationContext.setApplication(this.getClientProperties().getApplicationName());
        userAuthenticationContext.setCredential(credential);
        userAuthenticationContext.setName(username);
        userAuthenticationContext.setValidationFactors(this.getValidationFactors(request));
        return userAuthenticationContext;
    }

    private Cookie buildCookie(String token) throws InvalidAuthorizationTokenException, RemoteException {
        Cookie tokenCookie = new Cookie(this.getCookieTokenKey(), token);
        tokenCookie.setPath("/");
        SOAPCookieInfo cookieInfo = this.getSecurityServerClient().getCookieInfo();
        String domain = cookieInfo.getDomain();
        if (domain != null && domain.length() > 0 && !"localhost".equals(domain)) {
            tokenCookie.setDomain(domain);
        }
        tokenCookie.setSecure(cookieInfo.isSecure());
        return tokenCookie;
    }

    public ClientProperties getClientProperties() {
        return this.getSecurityServerClient().getClientProperties();
    }

    protected String getCookieTokenKey() {
        return this.getClientProperties().getCookieTokenKey();
    }

    public SecurityServerClient getSecurityServerClient() {
        return this.authenticationManager.getSecurityServerClient();
    }
}

