/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceDownloadUtils {
    private static final Log log = LogFactory.getLog(ResourceDownloadUtils.class);
    private static final long TEN_YEARS = 315360000000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serveFileImpl(HttpServletResponse httpServletResponse, InputStream in) throws IOException {
        ServletOutputStream out = httpServletResponse.getOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            log.error((Object)"Error serving the requested file: ", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            try {
                out.flush();
            }
            catch (IOException e) {
                log.warn((Object)"Error flushing output stream: ", (Throwable)e);
            }
        }
        log.debug((Object)"Serving file done.");
    }

    public static void addCachingHeaders(HttpServletResponse httpServletResponse, String ... cacheControls) {
        if (!Boolean.getBoolean("atlassian.disable.caches")) {
            httpServletResponse.setDateHeader("Expires", System.currentTimeMillis() + 315360000000L);
            httpServletResponse.setHeader("Cache-Control", "max-age=315360000000");
            for (String cacheControl : cacheControls) {
                httpServletResponse.addHeader("Cache-Control", cacheControl);
            }
        }
    }

    public static void addCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResourceDownloadUtils.addPublicCachingHeaders(httpServletRequest, httpServletResponse);
    }

    public static void addPublicCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResourceDownloadUtils.addCachingHeaders(httpServletResponse, "public");
    }

    public static void addPrivateCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResourceDownloadUtils.addCachingHeaders(httpServletResponse, "private");
    }
}

