/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class FastHashMap
implements Map,
Serializable {
    private HashMap map = null;

    public FastHashMap() {
        this.map = new HashMap();
    }

    public FastHashMap(int capacity) {
        this.map = new HashMap(capacity);
    }

    public FastHashMap(int capacity, float factor) {
        this.map = new HashMap(capacity, factor);
    }

    public FastHashMap(Map map) {
        this.map = new HashMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        FastHashMap fastHashMap = this;
        synchronized (fastHashMap) {
            HashMap temp = (HashMap)this.map.clone();
            temp.clear();
            this.map = temp;
        }
    }

    public Object clone() {
        return new FastHashMap(this.map);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map mo = (Map)o;
        if (mo.size() != this.map.size()) {
            return false;
        }
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            if (!(value == null ? mo.get(key) != null || !mo.containsKey(key) : !value.equals(mo.get(key)))) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public int hashCode() {
        int h = 0;
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        FastHashMap fastHashMap = this;
        synchronized (fastHashMap) {
            HashMap temp = (HashMap)this.map.clone();
            Object result = temp.put(key, value);
            this.map = temp;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map in) {
        FastHashMap fastHashMap = this;
        synchronized (fastHashMap) {
            HashMap temp = (HashMap)this.map.clone();
            temp.putAll(in);
            this.map = temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        FastHashMap fastHashMap = this;
        synchronized (fastHashMap) {
            HashMap temp = (HashMap)this.map.clone();
            Object result = temp.remove(key);
            this.map = temp;
            return result;
        }
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public String toString() {
        return this.map.toString();
    }
}

