/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.entities;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.config.ExternalReferenceResolver;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import com.opensymphony.xwork.util.location.Located;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PackageConfig
extends Located
implements Comparable,
Serializable {
    private static final Log LOG = LogFactory.getLog((Class)PackageConfig.class);
    private ExternalReferenceResolver externalRefResolver = null;
    private Map actionConfigs = new LinkedHashMap();
    private Map globalResultConfigs = new LinkedHashMap();
    private Map interceptorConfigs = new LinkedHashMap();
    private Map resultTypeConfigs = new LinkedHashMap();
    private List globalExceptionMappingConfigs = new ArrayList();
    private Set parents = new HashSet();
    private String defaultInterceptorRef;
    private String defaultActionRef;
    private String defaultResultType;
    private String name;
    private String namespace = "";
    private boolean isAbstract = false;

    public PackageConfig() {
    }

    public PackageConfig(String name) {
        this.name = name;
    }

    public PackageConfig(String name, String namespace, boolean isAbstract, ExternalReferenceResolver externalRefResolver) {
        this(name);
        this.namespace = TextUtils.noNull((String)namespace);
        this.isAbstract = isAbstract;
        this.externalRefResolver = externalRefResolver;
    }

    public PackageConfig(String name, String namespace, boolean isAbstract, ExternalReferenceResolver externalRefResolver, List parents) {
        this(name, namespace, isAbstract, externalRefResolver);
        Iterator iterator = parents.iterator();
        while (iterator.hasNext()) {
            PackageConfig parent = (PackageConfig)iterator.next();
            this.addParent(parent);
        }
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Map getActionConfigs() {
        return this.actionConfigs;
    }

    public Map getAllActionConfigs() {
        LinkedHashMap retMap = new LinkedHashMap();
        if (!this.parents.isEmpty()) {
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                PackageConfig parentContext = (PackageConfig)iterator.next();
                retMap.putAll(parentContext.getAllActionConfigs());
            }
        }
        retMap.putAll(this.getActionConfigs());
        return retMap;
    }

    public Map getAllGlobalResults() {
        LinkedHashMap retMap = new LinkedHashMap();
        if (!this.parents.isEmpty()) {
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                PackageConfig parentContext = (PackageConfig)iterator.next();
                retMap.putAll(parentContext.getAllGlobalResults());
            }
        }
        retMap.putAll(this.getGlobalResultConfigs());
        return retMap;
    }

    public Map getAllInterceptorConfigs() {
        LinkedHashMap retMap = new LinkedHashMap();
        if (!this.parents.isEmpty()) {
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                PackageConfig parentContext = (PackageConfig)iterator.next();
                retMap.putAll(parentContext.getAllInterceptorConfigs());
            }
        }
        retMap.putAll(this.getInterceptorConfigs());
        return retMap;
    }

    public Map getAllResultTypeConfigs() {
        LinkedHashMap retMap = new LinkedHashMap();
        if (!this.parents.isEmpty()) {
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                PackageConfig parentContext = (PackageConfig)iterator.next();
                retMap.putAll(parentContext.getAllResultTypeConfigs());
            }
        }
        retMap.putAll(this.getResultTypeConfigs());
        return retMap;
    }

    public List getAllExceptionMappingConfigs() {
        ArrayList allExceptionMappings = new ArrayList();
        if (!this.parents.isEmpty()) {
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                PackageConfig parentContext = (PackageConfig)iterator.next();
                allExceptionMappings.addAll(parentContext.getAllExceptionMappingConfigs());
            }
        }
        allExceptionMappings.addAll(this.getGlobalExceptionMappingConfigs());
        return allExceptionMappings;
    }

    public void setDefaultInterceptorRef(String name) {
        this.defaultInterceptorRef = name;
    }

    public String getDefaultInterceptorRef() {
        return this.defaultInterceptorRef;
    }

    public void setDefaultActionRef(String name) {
        this.defaultActionRef = name;
    }

    public String getDefaultActionRef() {
        return this.defaultActionRef;
    }

    public void setDefaultResultType(String defaultResultType) {
        this.defaultResultType = defaultResultType;
    }

    public String getDefaultResultType() {
        return this.defaultResultType;
    }

    public void setExternalRefResolver(ExternalReferenceResolver externalRefResolver) {
        this.externalRefResolver = externalRefResolver;
    }

    public ExternalReferenceResolver getExternalRefResolver() {
        if (this.externalRefResolver == null) {
            Iterator iter = this.getParents().iterator();
            while (iter.hasNext()) {
                PackageConfig packageConfig = (PackageConfig)iter.next();
                if (packageConfig.getExternalRefResolver() == null) continue;
                this.externalRefResolver = packageConfig.getExternalRefResolver();
                break;
            }
        }
        return this.externalRefResolver;
    }

    public String getFullDefaultInterceptorRef() {
        if (this.defaultInterceptorRef == null && !this.parents.isEmpty()) {
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                PackageConfig parent = (PackageConfig)iterator.next();
                String parentDefault = parent.getFullDefaultInterceptorRef();
                if (parentDefault == null) continue;
                return parentDefault;
            }
        }
        return this.defaultInterceptorRef;
    }

    public String getFullDefaultActionRef() {
        if (this.defaultActionRef == null && !this.parents.isEmpty()) {
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                PackageConfig parent = (PackageConfig)iterator.next();
                String parentDefault = parent.getFullDefaultActionRef();
                if (parentDefault == null) continue;
                return parentDefault;
            }
        }
        return this.defaultActionRef;
    }

    public String getFullDefaultResultType() {
        if (this.defaultResultType == null && !this.parents.isEmpty()) {
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                PackageConfig parent = (PackageConfig)iterator.next();
                String parentDefault = parent.getFullDefaultResultType();
                if (parentDefault == null) continue;
                return parentDefault;
            }
        }
        return this.defaultResultType;
    }

    public Map getGlobalResultConfigs() {
        return this.globalResultConfigs;
    }

    public Map getInterceptorConfigs() {
        return this.interceptorConfigs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace == null ? "" : namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List getParents() {
        return new ArrayList(this.parents);
    }

    public Map getResultTypeConfigs() {
        return this.resultTypeConfigs;
    }

    public List getGlobalExceptionMappingConfigs() {
        return this.globalExceptionMappingConfigs;
    }

    public void addActionConfig(String name, ActionConfig action) {
        this.actionConfigs.put(name, action);
    }

    public void addAllParents(List parents) {
        Iterator iterator = parents.iterator();
        while (iterator.hasNext()) {
            PackageConfig config = (PackageConfig)iterator.next();
            this.addParent(config);
        }
    }

    public void addGlobalResultConfig(ResultConfig resultConfig) {
        this.globalResultConfigs.put(resultConfig.getName(), resultConfig);
    }

    public void addGlobalResultConfigs(Map resultConfigs) {
        this.globalResultConfigs.putAll(resultConfigs);
    }

    public void addExceptionMappingConfig(ExceptionMappingConfig exceptionMappingConfig) {
        this.globalExceptionMappingConfigs.add(exceptionMappingConfig);
    }

    public void addGlobalExceptionMappingConfigs(List exceptionMappingConfigs) {
        this.globalExceptionMappingConfigs.addAll(exceptionMappingConfigs);
    }

    public void addInterceptorConfig(InterceptorConfig config) {
        this.interceptorConfigs.put(config.getName(), config);
    }

    public void addInterceptorStackConfig(InterceptorStackConfig config) {
        this.interceptorConfigs.put(config.getName(), config);
    }

    public void addParent(PackageConfig parent) {
        if (this.equals(parent)) {
            LOG.error((Object)("A package cannot extend itself: " + this.name));
        }
        this.parents.add(parent);
    }

    public void addResultTypeConfig(ResultTypeConfig config) {
        this.resultTypeConfigs.put(config.getName(), config);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageConfig)) {
            return false;
        }
        PackageConfig packageConfig = (PackageConfig)o;
        if (this.isAbstract != packageConfig.isAbstract) {
            return false;
        }
        if (this.actionConfigs != null ? !((Object)this.actionConfigs).equals(packageConfig.actionConfigs) : packageConfig.actionConfigs != null) {
            return false;
        }
        if (this.defaultResultType != null ? !this.defaultResultType.equals(packageConfig.defaultResultType) : packageConfig.defaultResultType != null) {
            return false;
        }
        if (this.globalResultConfigs != null ? !((Object)this.globalResultConfigs).equals(packageConfig.globalResultConfigs) : packageConfig.globalResultConfigs != null) {
            return false;
        }
        if (this.interceptorConfigs != null ? !((Object)this.interceptorConfigs).equals(packageConfig.interceptorConfigs) : packageConfig.interceptorConfigs != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(packageConfig.name) : packageConfig.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(packageConfig.namespace) : packageConfig.namespace != null) {
            return false;
        }
        if (this.parents != null ? !((Object)this.parents).equals(packageConfig.parents) : packageConfig.parents != null) {
            return false;
        }
        if (this.resultTypeConfigs != null ? !((Object)this.resultTypeConfigs).equals(packageConfig.resultTypeConfigs) : packageConfig.resultTypeConfigs != null) {
            return false;
        }
        return !(this.globalExceptionMappingConfigs != null ? !((Object)this.globalExceptionMappingConfigs).equals(packageConfig.globalExceptionMappingConfigs) : packageConfig.globalExceptionMappingConfigs != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.parents != null ? ((Object)this.parents).hashCode() : 0);
        result = 29 * result + (this.actionConfigs != null ? ((Object)this.actionConfigs).hashCode() : 0);
        result = 29 * result + (this.globalResultConfigs != null ? ((Object)this.globalResultConfigs).hashCode() : 0);
        result = 29 * result + (this.interceptorConfigs != null ? ((Object)this.interceptorConfigs).hashCode() : 0);
        result = 29 * result + (this.resultTypeConfigs != null ? ((Object)this.resultTypeConfigs).hashCode() : 0);
        result = 29 * result + (this.globalExceptionMappingConfigs != null ? ((Object)this.globalExceptionMappingConfigs).hashCode() : 0);
        result = 29 * result + (this.defaultResultType != null ? this.defaultResultType.hashCode() : 0);
        result = 29 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 29 * result + (this.isAbstract ? 1 : 0);
        return result;
    }

    public void removeParent(PackageConfig parent) {
        this.parents.remove(parent);
    }

    public String toString() {
        return "{PackageConfig Name:" + this.name + " namespace:" + this.namespace + " abstract:" + this.isAbstract + " parents:" + this.parents + "}";
    }

    public int compareTo(Object o) {
        PackageConfig other = (PackageConfig)o;
        String full = this.namespace + "!" + this.name;
        String otherFull = other.namespace + "!" + other.name;
        return full.compareTo(otherFull);
    }
}

