/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.model.principal.UserDAOHibernate;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.web.context.ServletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserMapper
extends GenericLegacyImporter
implements LegacyImporter,
ServletContextAware {
    protected static final String REMOTE_PRINCIPAL_XML_ROOT = "principals";
    protected static final String REMOTE_PRINCIPAL_XML_NODE = "principal";
    private static final String REMOTE_PRINCIPAL_XML_DIRECTORY_ID = "directoryId";
    private static final String REMOTE_PRINCIPAL_XML_CREDENTIAL_HISTORY_NODE = "credentialHistories";
    private static final String REMOTE_PRINCIPAL_XML_CREDENTIAL = "credential";
    private DirectoryDAOHibernate directoryDAO;
    private UserDAOHibernate userDAO;
    private ServletContext servletContext;

    @Override
    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element principalsElement = (Element)root.selectSingleNode("/crowd/ principals");
        if (principalsElement == null) {
            this.logger.error((Object)"No users were found for importing!");
            return;
        }
        ArrayList<UserTemplateWithCredentialAndAttributes> users = new ArrayList<UserTemplateWithCredentialAndAttributes>();
        Iterator userIter = principalsElement.elementIterator();
        while (userIter.hasNext()) {
            Element userElement = (Element)userIter.next();
            UserTemplateWithCredentialAndAttributes user = null;
            try {
                user = this.getUserAndAttributesFromXml(userElement, importData.getOldToNewDirectoryIds());
                users.add(user);
            }
            catch (IllegalArgumentException iae) {
                JohnsonEventContainer agentJohnson = JohnsonEventContainer.get((ServletContext)this.servletContext);
                JohnsonConfig johnsonConfig = JohnsonConfig.getInstance();
                try {
                    InternalEntityTemplate internalEntityTemplate = this.getInternalEntityTemplateFromLegacyXml(userElement);
                    Long directoryId = this.getUserDirectoryId(userElement);
                    String errorMessage = "Cannot import user <" + internalEntityTemplate.toFriendlyString() + "> into Directory <" + directoryId + ">, due to: " + iae.getMessage();
                    this.logger.error((Object)errorMessage, (Throwable)iae);
                    agentJohnson.addEvent(new Event(johnsonConfig.getEventType("import"), errorMessage, iae.getMessage(), johnsonConfig.getEventLevel("warning")));
                }
                catch (Exception e) {
                    this.logger.error((Object)"An error occured trying to parse user data during import", (Throwable)e);
                }
            }
        }
        BatchResultWithIdReferences result = this.userDAO.addAll(users);
        for (UserTemplateWithCredentialAndAttributes user : result.getFailedEntities()) {
            this.logger.error((Object)("Unable to add user <" + user.getName() + "> in directory with id <" + user.getDirectoryId() + ">"));
        }
        if (result.hasFailures()) {
            throw new ImportException("Unable to import all users. See logs for more details.");
        }
        importData.setUserImportResults((BatchResultWithIdReferences<User>)result);
    }

    protected UserTemplateWithCredentialAndAttributes getUserAndAttributesFromXml(Element userElement, Map<Long, Long> oldToNewDirectoryIds) {
        Long oldDirectoryId = this.getUserDirectoryId(userElement);
        Long directoryId = oldToNewDirectoryIds.get(oldDirectoryId);
        if (directoryId == null) {
            throw new IllegalArgumentException("User belongs to an unknown old directory with ID: " + directoryId);
        }
        Directory directory = (Directory)this.directoryDAO.loadReference(directoryId.longValue());
        InternalEntityTemplate internalEntityTemplate = this.getInternalEntityTemplateFromLegacyXml(userElement);
        internalEntityTemplate.setName(internalEntityTemplate.getName());
        internalEntityTemplate.setId(null);
        Map<String, List<String>> attributes = this.getMultiValuedAttributesMapFromXml(userElement);
        String firstName = this.getAttributeValue("givenName", attributes, "");
        String lastName = this.getAttributeValue("sn", attributes, "");
        String displayName = this.getAttributeValue("displayName", attributes, StringUtils.trimToEmpty((String)(firstName + " " + lastName)));
        String email = this.getAttributeValue("mail", attributes, "");
        PasswordCredential credential = this.getPasswordCredentialFromXml(userElement);
        UserTemplateWithCredentialAndAttributes userTemplate = new UserTemplateWithCredentialAndAttributes(internalEntityTemplate.getName(), directoryId, credential);
        userTemplate.setCreatedDate(internalEntityTemplate.getCreatedDate());
        userTemplate.setUpdatedDate(internalEntityTemplate.getUpdatedDate());
        userTemplate.setActive(internalEntityTemplate.isActive());
        userTemplate.setFirstName(firstName);
        userTemplate.setLastName(lastName);
        userTemplate.setDisplayName(displayName);
        userTemplate.setEmailAddress(email);
        userTemplate.setIconLocation(null);
        List<PasswordCredential> records = this.getCredentialHistory(userElement);
        userTemplate.getCredentialHistory().addAll(records);
        attributes.remove("givenName");
        attributes.remove("sn");
        attributes.remove("displayName");
        attributes.remove("mail");
        userTemplate.getAttributes().putAll(attributes);
        return userTemplate;
    }

    private long getUserDirectoryId(Element userElement) {
        return Long.parseLong(userElement.element(REMOTE_PRINCIPAL_XML_DIRECTORY_ID).getText());
    }

    private String getAttributeValue(String name, Map<String, List<String>> attributes, String defaultValue) {
        List<String> values = attributes.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return defaultValue;
    }

    private List<PasswordCredential> getCredentialHistory(Element userElement) {
        ArrayList<PasswordCredential> history = new ArrayList<PasswordCredential>();
        Element credentialHistoryNode = userElement.element(REMOTE_PRINCIPAL_XML_CREDENTIAL_HISTORY_NODE);
        if (credentialHistoryNode != null && credentialHistoryNode.hasContent()) {
            Iterator iterator = credentialHistoryNode.elementIterator(REMOTE_PRINCIPAL_XML_CREDENTIAL);
            while (iterator.hasNext()) {
                Element credentialElement = (Element)iterator.next();
                PasswordCredential credential = new PasswordCredential(credentialElement.getText(), true);
                history.add(credential);
            }
        }
        return history;
    }

    public void setDirectoryDAO(DirectoryDAOHibernate directoryDAO) {
        this.directoryDAO = directoryDAO;
    }

    public void setUserDAO(UserDAOHibernate userDAO) {
        this.userDAO = userDAO;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

