/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.property.PropertyDAOHibernate;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class SALPropertyMapper
extends GenericLegacyImporter
implements LegacyImporter {
    private final Logger logger = Logger.getLogger(this.getClass());
    private PropertyDAOHibernate propertyDAO;
    private static final String DIRECTORY_XML_ROOT = "salProperties";
    private static final String DIRECTORY_XML_NODE = "salProperty";
    private static final String SALPROPERTY_XML_KEY = "key";
    private static final String SALPROPERTY_XML_PROPERTY_NAME = "propertyName";
    private static final String SALPROPERTY_XML_STRING_VALUE = "propertyValue";

    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element salPropertiesElement = (Element)root.selectSingleNode("/crowd/ salProperties");
        if (salPropertiesElement == null) {
            this.logger.info((Object)"No sal properties were found for importing!");
        } else {
            Iterator salProperties = salPropertiesElement.elementIterator();
            while (salProperties.hasNext()) {
                Element salPropertyElement = (Element)salProperties.next();
                String key = salPropertyElement.element(SALPROPERTY_XML_KEY).getText();
                String propertyName = salPropertyElement.element(SALPROPERTY_XML_PROPERTY_NAME).getText();
                String stringValue = salPropertyElement.element(SALPROPERTY_XML_STRING_VALUE).getText();
                this.addEntityViaSave(new Property(key, propertyName, stringValue));
            }
        }
    }

    public void setPropertyDAO(PropertyDAOHibernate propertyDAO) {
        this.propertyDAO = propertyDAO;
    }
}

