/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.property.PropertyDAOHibernate;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class PropertyMapper
extends GenericLegacyImporter
implements LegacyImporter {
    private final Logger logger = Logger.getLogger(this.getClass());
    protected static final String PROPERTIES_XML_ROOT = "properties";
    protected static final String PROPERTY_XML_NODE = "property";
    protected static final String PROPERTY_XML_KEY = "key";
    protected static final String PROPERTY_XML_NAME = "name";
    protected static final String PROPERTY_XML_VALUE = "value";
    private PropertyDAOHibernate propertyDAO;
    private CrowdBootstrapManager bootstrapManager;

    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element propertiesElement = (Element)root.selectSingleNode("/crowd/ properties");
        if (propertiesElement == null) {
            this.logger.error((Object)"No properties were found for importing!");
        } else {
            Iterator properties = propertiesElement.elementIterator();
            while (properties.hasNext()) {
                String name;
                Element propertyElemet = (Element)properties.next();
                String codeName = propertyElemet.element(PROPERTY_XML_NAME).getText();
                String value = propertyElemet.element(PROPERTY_XML_VALUE).getText();
                if (codeName.equals("22") && StringUtils.isNotBlank((String)value)) {
                    try {
                        this.bootstrapManager.setServerID(value);
                    }
                    catch (ConfigurationException e) {
                        throw new ImportException((Exception)((Object)e));
                    }
                }
                if ((name = this.getNameFromLegacyCode(codeName)) == null) continue;
                this.addEntityViaSave(new Property("crowd", name, value));
            }
        }
    }

    private String getNameFromLegacyCode(String codeName) {
        int code = Integer.parseInt(codeName);
        switch (code) {
            case 1: {
                return "cache.time";
            }
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
            case 4: {
                return "token.seed";
            }
            case 5: {
                return null;
            }
            case 6: {
                return "deployment.title";
            }
            case 7: {
                return "domain";
            }
            case 8: {
                return "cache.enabled";
            }
            case 9: {
                return "session.time";
            }
            case 10: {
                return null;
            }
            case 11: {
                return "mailserver.host";
            }
            case 12: {
                return "mailserver.prefix";
            }
            case 13: {
                return "mailserver.sender";
            }
            case 14: {
                return "mailserver.username";
            }
            case 15: {
                return "mailserver.password";
            }
            case 16: {
                return "des.encryption.key";
            }
            case 17: {
                return "mailserver.message.template";
            }
            case 18: {
                return null;
            }
            case 19: {
                return null;
            }
            case 20: {
                return "current.license.resource.total";
            }
            case 21: {
                return "notification.email";
            }
            case 22: {
                return null;
            }
            case 23: {
                return "build.number";
            }
            case 24: {
                return "gzip.enabled";
            }
            case 25: {
                return "trusted.proxy.servers";
            }
            case 26: {
                return "database.token.storage.enabled";
            }
            case 27: {
                return "mailserver.jndi";
            }
            case 28: {
                return "mailserver.port";
            }
            case 29: {
                return "secure.cookie";
            }
        }
        return null;
    }

    public void setPropertyDAO(PropertyDAOHibernate propertyDAO) {
        this.propertyDAO = propertyDAO;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }
}

