/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyXmlVerifier {
    private List<String> errors = new ArrayList<String>();
    private Map<Long, Set<String>> directoryToRoleNames = new HashMap<Long, Set<String>>();
    private Map<Long, Set<String>> directoryToGroupNames = new HashMap<Long, Set<String>>();

    public void verify(Element root) {
        Element groupsElement = (Element)root.selectSingleNode("/crowd/ groups");
        Iterator remoteGroups = groupsElement.elementIterator();
        while (remoteGroups.hasNext()) {
            Element groupElement = (Element)remoteGroups.next();
            Long directoryId = Long.parseLong(groupElement.element("directoryId").getText());
            String groupName = groupElement.elementText("name");
            this.addGroupName(directoryId, groupName);
        }
        Element rolesElement = (Element)root.selectSingleNode("/crowd/ roles");
        Iterator remoteRoles = rolesElement.elementIterator();
        while (remoteRoles.hasNext()) {
            Element roleElement = (Element)remoteRoles.next();
            Long directoryId = Long.parseLong(roleElement.element("directoryId").getText());
            String roleName = roleElement.elementText("name");
            this.addRoleName(directoryId, roleName);
        }
    }

    private void addRoleName(Long directoryId, String roleName) {
        String standardRoleName = roleName.toLowerCase();
        Set<String> roleNames = this.directoryToRoleNames.get(directoryId);
        Set<String> groupNames = this.directoryToGroupNames.get(directoryId);
        if (roleNames == null) {
            roleNames = new HashSet<String>();
            this.directoryToRoleNames.put(directoryId, roleNames);
        }
        if (roleNames.contains(standardRoleName)) {
            this.errors.add("Could not add role with name '" + roleName + "' as it matches another role name in the same directory with id: " + directoryId);
        } else if (groupNames != null && groupNames.contains(standardRoleName)) {
            this.errors.add("Could not add role with name '" + roleName + "' as it matches another group name in the same directory with id: " + directoryId);
        } else {
            roleNames.add(standardRoleName);
        }
    }

    private void addGroupName(Long directoryId, String groupName) {
        String standardGroupName = groupName.toLowerCase();
        Set<String> roleNames = this.directoryToRoleNames.get(directoryId);
        Set<String> groupNames = this.directoryToGroupNames.get(directoryId);
        if (groupNames == null) {
            groupNames = new HashSet<String>();
            this.directoryToGroupNames.put(directoryId, groupNames);
        }
        if (groupNames.contains(standardGroupName)) {
            this.errors.add("Could not add group with name '" + groupName + "' as it matches another group name in the same directory with id: " + directoryId);
        } else if (roleNames != null && roleNames.contains(standardGroupName)) {
            this.errors.add("Could not add group with name '" + groupName + "' as it matches another role name in the same directory with id: " + directoryId);
        } else {
            groupNames.add(standardGroupName);
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

