/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.model.directory.OperationType;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericLegacyImporter {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss Z yyyy";
    public static final String GENERIC_XML_ID = "id";
    public static final String GENERIC_XML_NAME = "name";
    public static final String GENERIC_XML_ACTIVE = "active";
    public static final String GENERIC_XML_CONCEPTION = "conception";
    public static final String GENERIC_XML_LASTMODIFIED = "lastModified";
    public static final String GENERIC_XML_ATTRIBUTES_NODE = "attributes";
    public static final String GENERIC_XML_ATTRIBUTE = "attribute";
    public static final String GENERIC_XML_ATTRIBUTE_ID = "attributeId";
    public static final String GENERIC_XML_ATTRIBUTE_VALUES = "attributeValues";
    public static final String GENERIC_XML_ATTRIBUTE_VALUE = "attributeValue";
    public static final String GENERIC_XML_ATTRIBUTE_KEY = "attributeKey";
    private DirectoryManager directoryManager;
    private SessionFactory sessionFactory;
    private BatchProcessor batchProcessor;

    protected String getDateAsFormattedString(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    protected Date getDateFromFormattedString(String dateString) {
        Date date = null;
        if (StringUtils.isNotBlank((String)dateString)) {
            try {
                date = new SimpleDateFormat(DATE_FORMAT).parse(dateString);
            }
            catch (ParseException e) {
                this.logger.error((Object)("Failed to parse date: " + dateString), (Throwable)e);
            }
        }
        return date;
    }

    protected InternalEntityTemplate getInternalEntityTemplateFromLegacyXml(Element element) {
        InternalEntityTemplate template = new InternalEntityTemplate();
        template.setId(Long.valueOf(Long.parseLong(element.element(GENERIC_XML_ID).getText())));
        template.setName(element.element(GENERIC_XML_NAME).getText());
        template.setCreatedDate(this.getDateFromFormattedString(element.element(GENERIC_XML_CONCEPTION).getText()));
        template.setUpdatedDate(this.getDateFromFormattedString(element.element(GENERIC_XML_LASTMODIFIED).getText()));
        template.setActive(Boolean.parseBoolean(element.element(GENERIC_XML_ACTIVE).getText()));
        return template;
    }

    protected Object addEntityViaMerge(Object entityToPersist) throws ImportException {
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            if (session.isDirty()) {
                session.flush();
                session.connection().commit();
                session.clear();
            }
            session.merge(entityToPersist);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException e) {
            throw new ImportException(e);
        }
        return entityToPersist;
    }

    protected Object addEntityViaSave(Object entityToPersist) throws ImportException {
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            if (session.isDirty()) {
                session.flush();
                session.connection().commit();
                session.clear();
            }
            session.save(entityToPersist);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException e) {
            throw new ImportException(e);
        }
        return entityToPersist;
    }

    protected Map<String, List<String>> getMultiValuedAttributesMapFromXml(Element element) {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        Element attributesNode = element.element(GENERIC_XML_ATTRIBUTES_NODE);
        if (attributesNode != null && attributesNode.hasContent()) {
            Iterator iterator = attributesNode.elementIterator(GENERIC_XML_ATTRIBUTE);
            while (iterator.hasNext()) {
                Element attributeElement = (Element)iterator.next();
                String key = attributeElement.attributeValue(GENERIC_XML_ATTRIBUTE_KEY);
                Element attributeValuesElement = attributeElement.element(GENERIC_XML_ATTRIBUTE_VALUES);
                if (attributeValuesElement == null) continue;
                String attributeId = attributeValuesElement.attributeValue(GENERIC_XML_ATTRIBUTE_ID);
                ArrayList<String> values = new ArrayList<String>();
                Iterator attributeValuesIter = attributeValuesElement.elementIterator(GENERIC_XML_ATTRIBUTE_VALUE);
                while (attributeValuesIter.hasNext()) {
                    Element attributeValue = (Element)attributeValuesIter.next();
                    values.add(attributeValue.getText());
                }
                attributes.put(key, values);
            }
        }
        return attributes;
    }

    protected Map<String, String> getSingleValuedAttributesMapFromXml(Element element) {
        Map<String, List<String>> attributes = this.getMultiValuedAttributesMapFromXml(element);
        HashMap<String, String> singleValuedAttributes = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : attributes.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            singleValuedAttributes.put(entry.getKey(), entry.getValue().get(0));
        }
        return singleValuedAttributes;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public BatchProcessor getBatchProcessor() {
        return this.batchProcessor;
    }

    public void setBatchProcessor(BatchProcessor batchProcessor) {
        this.batchProcessor = batchProcessor;
    }

    protected OperationType getOperationTypeFromLegacyPermissionName(String name) {
        if (name.equals("principal.add")) {
            return OperationType.CREATE_USER;
        }
        if (name.equals("group.add")) {
            return OperationType.CREATE_GROUP;
        }
        if (name.equals("role.add")) {
            return OperationType.CREATE_ROLE;
        }
        if (name.equals("principal.modify")) {
            return OperationType.UPDATE_USER;
        }
        if (name.equals("group.modify")) {
            return OperationType.UPDATE_GROUP;
        }
        if (name.equals("role.modify")) {
            return OperationType.UPDATE_ROLE;
        }
        if (name.equals("principal.remove")) {
            return OperationType.DELETE_USER;
        }
        if (name.equals("group.remove")) {
            return OperationType.DELETE_GROUP;
        }
        if (name.equals("role.remove")) {
            return OperationType.DELETE_ROLE;
        }
        return null;
    }

    protected PasswordCredential getPasswordCredentialFromXml(Element parentElement) {
        Element credentialElement;
        Element credentialsNode = parentElement.element("credentials");
        if (credentialsNode != null && credentialsNode.hasContent() && (credentialElement = credentialsNode.element("credential")) != null) {
            return new PasswordCredential(credentialElement.getText(), true);
        }
        return new PasswordCredential("password", true);
    }
}

