/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.model.directory.OperationType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryMapper
extends GenericLegacyImporter
implements LegacyImporter {
    protected static final String DIRECTORY_XML_ROOT = "directories";
    protected static final String DIRECTORY_XML_NODE = "directory";
    private static final String DIRECTORY_XML_DESCRIPTION = "description";
    private static final String DIRECTORY_XML_IMPLEMENTATION_CLASS = "implementationClass";
    private static final String DIRECTORY_XML_TYPE = "type";
    private static final String DIRECTORY_XML_PERMISSIONS_NODE = "permissions";
    private static final String DIRECTORY_XML_PERMISSION = "permission";
    private static final String DIRECTORY_XML_PERMISSION_KEY = "key";
    private static final String DIRECTORY_XML_PERMISSION_VALUE = "value";

    @Override
    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element directoriesElement = (Element)root.selectSingleNode("/crowd/ directories");
        if (directoriesElement == null) {
            this.logger.error((Object)"No applications were found for importing!");
            return;
        }
        Iterator directories = directoriesElement.elementIterator();
        while (directories.hasNext()) {
            Element directoryElement = (Element)directories.next();
            this.importDirectoryFromXml(directoryElement, importData.getOldToNewDirectoryIds());
        }
    }

    protected Directory importDirectoryFromXml(Element directoryElement, Map<Long, Long> oldToNewDirectoryIds) throws ImportException {
        InternalEntityTemplate template = this.getInternalEntityTemplateFromLegacyXml(directoryElement);
        Long oldDirectoryId = template.getId();
        template.setId(null);
        Directory directory = new Directory(template);
        directory.setDescription(directoryElement.element(DIRECTORY_XML_DESCRIPTION).getText());
        directory.setType(this.getDirectoryTypeFromLegacyCode(Integer.parseInt(directoryElement.element(DIRECTORY_XML_TYPE).getText())));
        directory.setImplementationClass(directoryElement.element(DIRECTORY_XML_IMPLEMENTATION_CLASS).getText());
        Map<String, String> attributes = this.getSingleValuedAttributesMapFromXml(directoryElement);
        directory.setAttributes(attributes);
        Set<OperationType> permissions = this.getPermissions(directoryElement);
        directory.setAllowedOperations(permissions);
        Directory addedDirectory = (Directory)this.addEntityViaMerge(directory);
        Long newDirectoryId = addedDirectory.getId();
        oldToNewDirectoryIds.put(oldDirectoryId, newDirectoryId);
        return directory;
    }

    private DirectoryType getDirectoryTypeFromLegacyCode(int code) {
        switch (code) {
            case 0: {
                return DirectoryType.UNKNOWN;
            }
            case 1: {
                return DirectoryType.INTERNAL;
            }
            case 2: {
                return DirectoryType.CONNECTOR;
            }
            case 3: {
                return DirectoryType.CUSTOM;
            }
            case 4: {
                return DirectoryType.DELEGATING;
            }
        }
        throw new IllegalArgumentException("Code is not valid");
    }

    private Set<OperationType> getPermissions(Element element) {
        HashSet<OperationType> permissions = new HashSet<OperationType>();
        Element permissionsNode = element.element(DIRECTORY_XML_PERMISSIONS_NODE);
        if (permissionsNode != null && permissionsNode.hasContent()) {
            Iterator iterator = permissionsNode.elementIterator(DIRECTORY_XML_PERMISSION);
            while (iterator.hasNext()) {
                OperationType operationType;
                Element permissionElement = (Element)iterator.next();
                if (!Boolean.valueOf(permissionElement.attributeValue(DIRECTORY_XML_PERMISSION_VALUE)).booleanValue() || (operationType = this.getOperationTypeFromLegacyPermissionName(permissionElement.attributeValue(DIRECTORY_XML_PERMISSION_KEY))) == null) continue;
                permissions.add(operationType);
            }
        } else {
            permissions.addAll(Arrays.asList(OperationType.values()));
        }
        return permissions;
    }
}

