/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.membership.InternalMembership;
import com.atlassian.crowd.integration.model.membership.MembershipType;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.GenericMapper;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.model.membership.MembershipDAOHibernate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MembershipMapper
extends GenericMapper
implements Mapper {
    private MembershipDAOHibernate membershipDAO;
    private DirectoryDAOHibernate directoryDAO;
    protected static final String MEMBERSHIP_XML_ROOT = "memberships";
    private static final String MEMBERSHIP_XML_NODE = "membership";
    private static final String MEMBERSHIP_XML_DIRECTORY_ID = "directoryId";
    private static final String MEMBERSHIP_XML_PARENT_NAME = "parentName";
    private static final String MEMBERSHIP_XML_CHILD_NAME = "childName";
    private static final String MEMBERSHIP_XML_PARENT_ID = "parentId";
    private static final String MEMBERSHIP_XML_CHILD_ID = "childId";
    private static final String MEMBERSHIP_XML_MEMBERSHIP_TYPE = "membershipType";
    private static final String MEMBERSHIP_XML_MEMBERSHIP_GROUP_TYPE = "groupType";

    public Element exportXml(Map options) throws ExportException {
        Element membershipRoot = DocumentHelper.createElement((String)MEMBERSHIP_XML_ROOT);
        List memberships = this.membershipDAO.findAll();
        for (InternalMembership membership : memberships) {
            this.addMembershipToXml(membership, membershipRoot);
        }
        return membershipRoot;
    }

    protected void addMembershipToXml(InternalMembership membership, Element membershipRoot) {
        Element membershipElement = membershipRoot.addElement(MEMBERSHIP_XML_NODE);
        membershipElement.addElement("id").addText(membership.getId().toString());
        membershipElement.addElement(MEMBERSHIP_XML_DIRECTORY_ID).addText(membership.getDirectory().getId().toString());
        membershipElement.addElement(MEMBERSHIP_XML_PARENT_NAME).addText(membership.getParentName());
        membershipElement.addElement(MEMBERSHIP_XML_CHILD_NAME).addText(membership.getChildName());
        membershipElement.addElement(MEMBERSHIP_XML_PARENT_ID).addText(membership.getParentId().toString());
        membershipElement.addElement(MEMBERSHIP_XML_CHILD_ID).addText(membership.getChildId().toString());
        membershipElement.addElement(MEMBERSHIP_XML_MEMBERSHIP_TYPE).addText(membership.getMembershipType().name());
        membershipElement.addElement(MEMBERSHIP_XML_MEMBERSHIP_GROUP_TYPE).addText(membership.getGroupType().name());
    }

    public void importXml(Element root) throws ImportException {
        Element membershipsElement = (Element)root.selectSingleNode("/crowd/ memberships");
        if (membershipsElement == null) {
            this.logger.error((Object)"No memberships were found for importing!");
            return;
        }
        ArrayList<InternalMembership> membershipsToReplicate = new ArrayList<InternalMembership>();
        Iterator membershipIter = membershipsElement.elementIterator();
        while (membershipIter.hasNext()) {
            Element membershipElement = (Element)membershipIter.next();
            InternalMembership membership = this.getMembershipFromXml(membershipElement);
            membershipsToReplicate.add(membership);
        }
        this.logger.info((Object)("About to replicate " + membershipsToReplicate.size() + " memberships"));
        this.addEntities(membershipsToReplicate);
        this.logger.info((Object)"Membership replication complete");
    }

    protected InternalMembership getMembershipFromXml(Element membershipElement) {
        Long id = Long.parseLong(membershipElement.element("id").getText());
        Long directoryId = Long.parseLong(membershipElement.element(MEMBERSHIP_XML_DIRECTORY_ID).getText());
        Long childId = Long.parseLong(membershipElement.element(MEMBERSHIP_XML_CHILD_ID).getText());
        Long parentId = Long.parseLong(membershipElement.element(MEMBERSHIP_XML_PARENT_ID).getText());
        String childName = membershipElement.element(MEMBERSHIP_XML_CHILD_NAME).getText();
        String parentName = membershipElement.element(MEMBERSHIP_XML_PARENT_NAME).getText();
        MembershipType membershipType = MembershipType.valueOf((String)membershipElement.element(MEMBERSHIP_XML_MEMBERSHIP_TYPE).getText());
        GroupType groupType = GroupType.valueOf((String)membershipElement.element(MEMBERSHIP_XML_MEMBERSHIP_GROUP_TYPE).getText());
        Directory directoryReference = (Directory)this.directoryDAO.loadReference(directoryId.longValue());
        return new InternalMembership(id, parentId, childId, membershipType, groupType, parentName, childName, directoryReference);
    }

    public void setMembershipDAO(MembershipDAOHibernate membershipDAO) {
        this.membershipDAO = membershipDAO;
    }

    public void setDirectoryDAO(DirectoryDAOHibernate directoryDAO) {
        this.directoryDAO = directoryDAO;
    }
}

